/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventoryWithContainer;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.inventory.ExtractOnlyItemStackHandler;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;

public class InventoryScannerBlockEntity
extends DisguisableBlockEntity
implements IModuleInventoryWithContainer,
MenuProvider,
ITickingBlockEntity,
ILockable,
ContainerListener {
    private Option.BooleanOption horizontal = new Option.BooleanOption("horizontal", false);
    private Option.BooleanOption solidifyField = new Option.BooleanOption("solidifyField", false);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private NonNullList<ItemStack> inventoryContents = NonNullList.withSize((int)37, (Object)ItemStack.EMPTY);
    private boolean providePower;
    private int signalCooldown;
    private int togglePowerCooldown;
    private LensContainer lens = new LensContainer(1);

    public InventoryScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.togglePowerCooldown > 0) {
            --this.togglePowerCooldown;
        }
        if (this.signalCooldown > 0) {
            --this.signalCooldown;
        } else if (this.providePower && (Integer)this.signalLength.get() > 0) {
            this.togglePowerOutput();
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos, this.getBlockState(), be -> be.setOwner(this.getOwner().getUUID(), this.getOwner().getName()));
        if (connectedScanner != null) {
            connectedScanner.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.isClientSide) {
                level.getServer().getPlayerList().broadcastAll((Packet)connectedScanner.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventoryContents, (HolderLookup.Provider)lookupProvider);
        this.signalCooldown = tag.getInt("cooldown");
        this.providePower = tag.getBoolean("is_providing_power");
        this.lens.fromTag(tag.getList("lens", 10), lookupProvider);
        this.lens.setChanged();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventoryContents, (HolderLookup.Provider)lookupProvider);
        tag.putInt("cooldown", this.signalCooldown);
        tag.putBoolean("is_providing_power", this.providePower);
        tag.put("lens", (Tag)this.lens.createTag(lookupProvider));
    }

    @Override
    public int getContainerSize() {
        return 37;
    }

    @Override
    public ItemStack removeContainerItem(int index, int count, boolean simulate) {
        if (!((ItemStack)this.inventoryContents.get(index)).isEmpty()) {
            if (((ItemStack)this.inventoryContents.get(index)).getCount() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                if (!simulate) {
                    this.inventoryContents.set(index, (Object)ItemStack.EMPTY);
                    this.setChanged();
                }
                return stack.copy();
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).split(count);
            if (!simulate && ((ItemStack)this.inventoryContents.get(index)).getCount() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.EMPTY);
                this.setChanged();
            }
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return !this.isContainer(slot) ? this.getModuleInSlot(slot) : this.getStackInContainer(slot);
    }

    @Override
    public ItemStack getStackInContainer(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public List<ItemStack> getAllProhibitedItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 10; ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).isEmpty()) continue;
            stacks.add((ItemStack)this.inventoryContents.get(i));
        }
        return stacks;
    }

    @Override
    public void setContainerItem(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getContainerStackSize()) {
            stack.setCount(this.getContainerStackSize());
        }
        this.setChanged();
    }

    public ItemStack addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).isEmpty(); ++i) {
        }
        return remainder;
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.isEmpty() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.getStackInSlot(slot);
        int limit = stackToInsert.getItem().getMaxStackSize(stackToInsert);
        if (slotStack.isEmpty()) {
            this.setContainerItem(slot, stackToInsert);
            this.setChanged();
            return ItemStack.EMPTY;
        }
        if (InventoryScannerFieldBlock.areItemStacksEqual(slotStack, stackToInsert) && slotStack.getCount() < limit) {
            if (limit - slotStack.getCount() >= stackToInsert.getCount()) {
                slotStack.setCount(slotStack.getCount() + stackToInsert.getCount());
                this.setChanged();
                return ItemStack.EMPTY;
            }
            ItemStack toInsert = stackToInsert.copy();
            ItemStack toReturn = toInsert.split(slotStack.getCount() + stackToInsert.getCount() - limit);
            slotStack.setCount(slotStack.getCount() + toInsert.getCount());
            this.setChanged();
            return toReturn;
        }
        return stackToInsert;
    }

    public LensContainer getLensContainer() {
        return this.lens;
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        InventoryScannerBlockEntity otherScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition, this.getBlockState(), be -> {
            if (be.getLevel().isClientSide) {
                ClientHandler.updateBlockColorAroundPosition(be.getBlockPos());
            }
        });
        if (otherScanner != null) {
            otherScanner.getLensContainer().setItemExclusively(0, this.lens.getItem(0));
        }
    }

    public static IItemHandler getCapability(InventoryScannerBlockEntity be, Direction side) {
        if (BlockUtils.isAllowedToExtractFromProtectedObject(side, be)) {
            return new ExtractOnlyItemStackHandler((NonNullList)be.inventoryContents){

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return slot < 10 ? ItemStack.EMPTY : super.extractItem(slot, amount, simulate);
                }
            };
        }
        return EmptyItemHandler.INSTANCE;
    }

    @Override
    public boolean isItemValidForContainer(int index, ItemStack stack) {
        return false;
    }

    public boolean isProvidingPower() {
        return this.isModuleEnabled(ModuleType.REDSTONE) && this.providePower;
    }

    public boolean wantsToProvidePower() {
        return this.providePower;
    }

    public void togglePowerOutput() {
        boolean shouldTurnOffAgain;
        int signalLength = (Integer)this.signalLength.get();
        boolean bl = shouldTurnOffAgain = signalLength > 0;
        if (!shouldTurnOffAgain && this.togglePowerCooldown > 0) {
            this.togglePowerCooldown = 5;
        } else {
            if (!shouldTurnOffAgain || this.signalCooldown <= 0) {
                this.togglePowerCooldown = 5;
                this.providePower = !this.providePower;
                BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.INVENTORY_SCANNER.get());
                this.setChanged();
            }
            if (this.providePower && shouldTurnOffAgain) {
                this.signalCooldown = signalLength;
            }
        }
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
        this.setChanged();
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null && (toggled ? !connectedScanner.isModuleEnabled(module) : !connectedScanner.hasModule(module))) {
            connectedScanner.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(this, stack);
            if (connectedScanner != null) {
                this.onInsertDisguiseModule(connectedScanner, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null && (toggled ? connectedScanner.isModuleEnabled(module) : connectedScanner.hasModule(module))) {
            connectedScanner.removeModule(module, toggled);
        }
        if (module == ModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.getContainerSize(); ++i) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 10; i < connectedScanner.getContainerSize(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.EMPTY);
                }
            }
        } else if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(this);
            if (connectedScanner != null) {
                this.onRemoveDisguiseModule(connectedScanner);
            }
        }
    }

    private void onInsertDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.getLevel().isClientSide) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
    }

    private void onRemoveDisguiseModule(BlockEntity be) {
        if (!be.getLevel().isClientSide) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    @Override
    public boolean shouldDropModules() {
        return InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition) == null;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.STORAGE, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        Option<T> option2 = option;
        Objects.requireNonNull(option2);
        Option<T> option3 = option2;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Option.BooleanOption.class, Option.BooleanOption.class, Option.BooleanOption.class, Option.BooleanOption.class, Option.IntOption.class}, option3, n)) {
                case 0: {
                    Option.BooleanOption bo = (Option.BooleanOption)option3;
                    if (option != this.horizontal) {
                        n = 1;
                        continue block7;
                    }
                    this.modifyFields((offsetPos, state) -> this.level.setBlockAndUpdate(offsetPos, (BlockState)state.setValue((Property)InventoryScannerFieldBlock.HORIZONTAL, (Comparable)((Boolean)bo.get()))), connectedScanner -> connectedScanner.setHorizontal((Boolean)bo.get()));
                    this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)((Boolean)bo.get())));
                    break block7;
                }
                case 1: {
                    Option.BooleanOption bo = (Option.BooleanOption)option3;
                    if (option != this.solidifyField) {
                        n = 2;
                        continue block7;
                    }
                    InventoryScannerBlockEntity connectedScanner2 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
                    if (connectedScanner2 == null) break block7;
                    connectedScanner2.setSolidifyField((Boolean)bo.get());
                    break block7;
                }
                case 2: {
                    Option.BooleanOption bo = (Option.BooleanOption)option3;
                    if (option != this.disabled) {
                        n = 3;
                        continue block7;
                    }
                    if (!((Boolean)bo.get()).booleanValue()) {
                        InventoryScannerBlock.checkAndPlaceAppropriately(this.level, this.worldPosition, true);
                        break block7;
                    }
                    this.modifyFields((offsetPos, state) -> this.level.destroyBlock(offsetPos, false), connectedScanner -> connectedScanner.setDisabled(true));
                    break block7;
                }
                case 3: {
                    Option.BooleanOption bo = (Option.BooleanOption)option3;
                    if (option != this.ignoreOwner) {
                        n = 4;
                        continue block7;
                    }
                    InventoryScannerBlockEntity connectedScanner3 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
                    if (connectedScanner3 == null) break block7;
                    connectedScanner3.setIgnoresOwner((Boolean)bo.get());
                    break block7;
                }
                case 4: {
                    Option.IntOption io = (Option.IntOption)option3;
                    if (option != this.signalLength) {
                        n = 5;
                        continue block7;
                    }
                    InventoryScannerBlockEntity connectedScanner4 = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
                    if (connectedScanner4 == null) break block7;
                    connectedScanner4.setSignalLength((Integer)io.get());
                    break block7;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled option synchronization in inventory scanner! " + option.getName());
                }
            }
            break;
        }
        super.onOptionChanged(option);
    }

    private void modifyFields(BiConsumer<BlockPos, BlockState> blockSetter, Consumer<InventoryScannerBlockEntity> connectedScannerModifier) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.level, this.worldPosition);
        if (connectedScanner != null) {
            Direction facing = (Direction)this.getBlockState().getValue(InventoryScannerBlock.FACING);
            connectedScannerModifier.accept(connectedScanner);
            for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                BlockPos offsetPos = this.worldPosition.relative(facing, i);
                BlockState state = this.level.getBlockState(offsetPos);
                Block block = state.getBlock();
                if (block == SCContent.INVENTORY_SCANNER_FIELD.get()) {
                    blockSetter.accept(offsetPos, state);
                    continue;
                }
                if (!state.isAir() && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get() || block == SCContent.INVENTORY_SCANNER.get() && state.getValue(InventoryScannerBlock.FACING) == facing.getOpposite()) break;
            }
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        if ((Boolean)this.horizontal.get() != isHorizontal) {
            this.horizontal.setValue(isHorizontal);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
            this.setChanged();
        }
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        if (this.doesFieldSolidify() != shouldSolidify) {
            this.solidifyField.setValue(shouldSolidify);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            this.disabled.setValue(disabled);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            this.ignoreOwner.setValue(ignoresOwner);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public void setSignalLength(int signalLength) {
        this.signalLength.setValue(signalLength);
        this.togglePowerCooldown = 5;
        this.providePower = false;
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField, this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new InventoryScannerMenu(windowId, this.level, this.worldPosition, inv);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Override
    public boolean isContainerEmpty() {
        return this.inventoryContents.isEmpty();
    }
}

