/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBaseBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonHeadBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMath;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedPistonMovingBlockEntity
extends BlockEntity
implements IOwnable {
    private BlockState movedState;
    private CompoundTag movedBlockEntityTag;
    private Direction direction;
    private boolean extending;
    private boolean isSourcePiston;
    private static final ThreadLocal<Direction> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;
    private int deathTicks;
    private Owner owner = new Owner();

    public ReinforcedPistonMovingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), pos, state);
    }

    public ReinforcedPistonMovingBlockEntity(BlockPos pos, BlockState state, BlockState movedState, CompoundTag tag, Direction direction, boolean extending, boolean shouldHeadBeRendered) {
        this(pos, state);
        this.movedState = movedState;
        this.movedBlockEntityTag = tag;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = shouldHeadBeRendered;
        this.owner = Owner.fromCompound(tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getFacing() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return Mth.lerp((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    public float getOffsetX(float ticks) {
        return (float)this.direction.getStepX() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.direction.getStepY() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.direction.getStepZ() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.isSourcePiston() && this.movedState.getBlock() instanceof ReinforcedPistonBaseBlock ? (BlockState)((BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).defaultBlockState().setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(this.progress > 0.25f))).setValue((Property)PistonHeadBlock.TYPE, (Comparable)(this.movedState.is((Block)SCContent.REINFORCED_STICKY_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT))).setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)this.movedState.getValue((Property)DirectionalBlock.FACING))) : this.movedState;
    }

    private static void moveCollidedEntities(Level level, BlockPos pos, float progress, ReinforcedPistonMovingBlockEntity be) {
        AABB boundingBox;
        List list;
        Direction direction = be.getMovementDirection();
        double progressChange = progress - be.progress;
        VoxelShape collisionShape = be.getCollisionRelatedBlockState().getCollisionShape((BlockGetter)level, pos);
        if (!collisionShape.isEmpty() && !(list = level.getEntities(null, PistonMath.getMovementArea((AABB)(boundingBox = ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, collisionShape.bounds(), be)), (Direction)direction, (double)progressChange).minmax(boundingBox))).isEmpty()) {
            List boundingBoxes = collisionShape.toAabbs();
            boolean isSlimeBlock = be.movedState.isSlimeBlock();
            Iterator entities = list.iterator();
            while (true) {
                AABB entityCollision;
                AABB aabb;
                AABB movementArea;
                if (!entities.hasNext()) {
                    return;
                }
                Entity entity = (Entity)entities.next();
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                if (isSlimeBlock) {
                    if (entity instanceof ServerPlayer) continue;
                    Vec3 vec3 = entity.getDeltaMovement();
                    double x = vec3.x;
                    double y = vec3.y;
                    double z = vec3.z;
                    switch (direction.getAxis()) {
                        case X: {
                            x = direction.getStepX();
                            break;
                        }
                        case Y: {
                            y = direction.getStepY();
                            break;
                        }
                        case Z: {
                            z = direction.getStepZ();
                        }
                    }
                    entity.setDeltaMovement(x, y, z);
                }
                double d4 = 0.0;
                Iterator iterator = boundingBoxes.iterator();
                while (!(!iterator.hasNext() || (movementArea = PistonMath.getMovementArea((AABB)ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, aabb = (AABB)iterator.next(), be), (Direction)direction, (double)progressChange)).intersects(entityCollision = entity.getBoundingBox()) && (d4 = Math.max(d4, ReinforcedPistonMovingBlockEntity.getMovement(movementArea, direction, entityCollision))) >= progressChange)) {
                }
                if (!(d4 > 0.0)) continue;
                d4 = Math.min(d4, progressChange) + 0.01;
                ReinforcedPistonMovingBlockEntity.moveEntityByPiston(direction, entity, d4, direction);
                if (be.extending || !be.isSourcePiston) continue;
                ReinforcedPistonMovingBlockEntity.fixEntityWithinPistonBase(pos, entity, direction, progressChange);
            }
        }
    }

    private static void moveEntityByPiston(Direction direction, Entity entity, double progress, Direction moveDirection) {
        NOCLIP.set(direction);
        entity.move(MoverType.PISTON, new Vec3(progress * (double)moveDirection.getStepX(), progress * (double)moveDirection.getStepY(), progress * (double)moveDirection.getStepZ()));
        entity.applyEffectsFromBlocks();
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(Level level, BlockPos pos, float progress, ReinforcedPistonMovingBlockEntity be) {
        Direction direction;
        if (be.isStickyForEntities() && (direction = be.getMovementDirection()).getAxis().isHorizontal()) {
            double collisionShapeTop = be.movedState.getCollisionShape((BlockGetter)level, pos).max(Direction.Axis.Y);
            AABB aabb = ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, new AABB(0.0, collisionShapeTop, 0.0, 1.0, 1.5000000999999998, 1.0), be);
            double progressChange = progress - be.progress;
            for (Entity entity2 : level.getEntities((Entity)null, aabb, entity -> ReinforcedPistonMovingBlockEntity.matchesStickyCriteria(aabb, entity))) {
                ReinforcedPistonMovingBlockEntity.moveEntityByPiston(direction, entity2, progressChange, direction);
            }
        }
    }

    private static boolean matchesStickyCriteria(AABB shape, Entity entity) {
        return entity.getPistonPushReaction() == PushReaction.NORMAL && entity.onGround() && entity.getX() >= shape.minX && entity.getX() <= shape.maxX && entity.getZ() >= shape.minZ && entity.getZ() <= shape.maxZ;
    }

    private boolean isStickyForEntities() {
        return this.movedState.is(Blocks.HONEY_BLOCK);
    }

    public Direction getMovementDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    private static double getMovement(AABB headShape, Direction direction, AABB facing) {
        return switch (direction) {
            case Direction.EAST -> headShape.maxX - facing.minX;
            case Direction.WEST -> facing.maxX - headShape.minX;
            case Direction.DOWN -> facing.maxY - headShape.minY;
            case Direction.SOUTH -> headShape.maxZ - facing.minZ;
            case Direction.NORTH -> facing.maxZ - headShape.minZ;
            default -> headShape.maxY - facing.minY;
        };
    }

    private static AABB moveByPositionAndProgress(BlockPos pos, AABB boundingBox, ReinforcedPistonMovingBlockEntity be) {
        double extendedProgress = be.getExtendedProgress(be.progress);
        return boundingBox.move((double)pos.getX() + extendedProgress * (double)be.direction.getStepX(), (double)pos.getY() + extendedProgress * (double)be.direction.getStepY(), (double)pos.getZ() + extendedProgress * (double)be.direction.getStepZ());
    }

    private static void fixEntityWithinPistonBase(BlockPos pos, Entity entity, Direction pushDirection, double progress) {
        double d1;
        Direction direction;
        double d0;
        AABB pistonBoundingBox;
        AABB entityBoundingBox = entity.getBoundingBox();
        if (entityBoundingBox.intersects(pistonBoundingBox = Shapes.block().bounds().move(pos)) && Math.abs((d0 = ReinforcedPistonMovingBlockEntity.getMovement(pistonBoundingBox, direction = pushDirection.getOpposite(), entityBoundingBox) + 0.01) - (d1 = ReinforcedPistonMovingBlockEntity.getMovement(pistonBoundingBox, direction, entityBoundingBox.intersect(pistonBoundingBox)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, progress) + 0.01;
            ReinforcedPistonMovingBlockEntity.moveEntityByPiston(pushDirection, entity, d0, direction);
        }
    }

    public BlockState getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.level != null && (this.lastProgress < 1.0f || this.level.isClientSide)) {
            this.lastProgress = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).is((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                BlockState pushedState = this.isSourcePiston ? Blocks.AIR.defaultBlockState() : Block.updateFromNeighbourShapes((BlockState)this.movedState, (LevelAccessor)this.level, (BlockPos)this.worldPosition);
                if (this.movedBlockEntityTag != null) {
                    BlockEntity be;
                    BlockEntity blockEntity = be = pushedState.hasBlockEntity() ? ((EntityBlock)pushedState.getBlock()).newBlockEntity(this.worldPosition, pushedState) : null;
                    if (be != null) {
                        be.blockState = this.getBlockState();
                        be.loadWithComponents(this.movedBlockEntityTag, (HolderLookup.Provider)this.level.registryAccess());
                        this.level.setBlockEntity(be);
                        if (be instanceof IModuleInventory) {
                            IModuleInventory moduleInv = (IModuleInventory)be;
                            moduleInv.getInsertedModules().forEach(type -> {
                                if (moduleInv.isModuleEnabled((ModuleType)((Object)type))) {
                                    moduleInv.onModuleInserted(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                } else {
                                    moduleInv.onModuleRemoved(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                }
                            });
                        }
                    }
                }
                this.level.setBlock(this.worldPosition, pushedState, 3);
                this.level.neighborChanged(this.worldPosition, pushedState.getBlock(), ExperimentalRedstoneUtils.initialOrientation((Level)this.level, (Direction)this.getPushDirection(), null));
            }
        }
    }

    public Direction getPushDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReinforcedPistonMovingBlockEntity be) {
        be.lastTicked = level.getGameTime();
        be.lastProgress = be.progress;
        if (be.lastProgress >= 1.0f) {
            if (level.isClientSide && be.deathTicks < 5) {
                ++be.deathTicks;
            } else {
                level.removeBlockEntity(pos);
                be.setRemoved();
                if (be.movedState != null && level.getBlockState(pos).is((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                    BlockState pushedState = Block.updateFromNeighbourShapes((BlockState)be.movedState, (LevelAccessor)level, (BlockPos)pos);
                    if (pushedState.isAir()) {
                        level.setBlock(pos, be.movedState, 84);
                        Block.updateOrDestroy((BlockState)be.movedState, (BlockState)pushedState, (LevelAccessor)level, (BlockPos)pos, (int)3);
                    } else {
                        if (pushedState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)pushedState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                            pushedState = (BlockState)pushedState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                        }
                        if (be.movedBlockEntityTag != null) {
                            BlockEntity storedBe;
                            BlockEntity blockEntity = storedBe = pushedState.hasBlockEntity() ? ((EntityBlock)pushedState.getBlock()).newBlockEntity(be.worldPosition, pushedState) : null;
                            if (storedBe != null) {
                                storedBe.blockState = be.getBlockState();
                                storedBe.loadWithComponents(be.movedBlockEntityTag, (HolderLookup.Provider)level.registryAccess());
                                level.setBlockEntity(storedBe);
                                if (storedBe instanceof IModuleInventory) {
                                    IModuleInventory moduleInv = (IModuleInventory)storedBe;
                                    moduleInv.getInsertedModules().forEach(type -> {
                                        if (moduleInv.isModuleEnabled((ModuleType)((Object)type))) {
                                            moduleInv.onModuleInserted(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                        } else {
                                            moduleInv.onModuleRemoved(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                        }
                                    });
                                }
                            }
                        }
                        level.setBlock(pos, pushedState, 67);
                        level.neighborChanged(pos, pushedState.getBlock(), ExperimentalRedstoneUtils.initialOrientation((Level)level, (Direction)be.getPushDirection(), null));
                    }
                }
            }
        } else {
            float f = be.progress + 0.5f;
            ReinforcedPistonMovingBlockEntity.moveCollidedEntities(level, pos, f, be);
            ReinforcedPistonMovingBlockEntity.moveStuckEntities(level, pos, f, be);
            be.progress = f;
            if (be.progress >= 1.0f) {
                be.progress = 1.0f;
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        DefaultedRegistry holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK;
        this.movedState = NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)tag.getCompound("blockState"));
        this.direction = Direction.from3DDataValue((int)tag.getInt("facing"));
        this.lastProgress = this.progress = tag.getFloat("progress");
        this.extending = tag.getBoolean("extending");
        this.isSourcePiston = tag.getBoolean("source");
        this.movedBlockEntityTag = (CompoundTag)tag.get("movedBlockEntityTag");
        this.owner.load(tag);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.put("blockState", (Tag)NbtUtils.writeBlockState((BlockState)this.movedState));
        tag.putInt("facing", this.direction.get3DDataValue());
        tag.putFloat("progress", this.lastProgress);
        tag.putBoolean("extending", this.extending);
        tag.putBoolean("source", this.isSourcePiston);
        if (this.movedBlockEntityTag != null) {
            tag.put("movedBlockEntityTag", (Tag)this.movedBlockEntityTag);
        }
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
    }

    public VoxelShape getCollisionShape(BlockGetter level, BlockPos pos) {
        VoxelShape shape = !this.extending && this.isSourcePiston ? ((BlockState)this.movedState.setValue((Property)PistonBaseBlock.EXTENDED, (Comparable)Boolean.valueOf(true))).getCollisionShape(level, pos) : Shapes.empty();
        if ((double)this.progress < 1.0 && NOCLIP.get() == this.getMovementDirection()) {
            return shape;
        }
        BlockState state = this.isSourcePiston() ? (BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)this.direction)).setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 4.0f)) : this.movedState;
        float extendedProgress = this.getExtendedProgress(this.progress);
        double x = (float)this.direction.getStepX() * extendedProgress;
        double y = (float)this.direction.getStepY() * extendedProgress;
        double z = (float)this.direction.getStepZ() * extendedProgress;
        return Shapes.or((VoxelShape)shape, (VoxelShape)state.getCollisionShape(level, pos).move(x, y, z));
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

