/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceBakedModel;
import net.geforcemods.securitycraft.particle.InterfaceHighlightParticleOptions;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class SecureRedstoneInterfaceBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity {
    public static final Vector3f SENDER_PARTICLE_COLOR = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f RECEIVER_PARTICLE_COLOR = new Vector3f(1.0f, 1.0f, 0.0f);
    public static final Vector3f RECEIVER_PARTICLE_COLOR_NO_SIGNAL = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f RECEIVER_PROTECTED_PARTICLE_COLOR = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL = new Vector3f(0.0f, 0.0f, 0.0f);
    public final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private boolean tracked = false;
    private boolean refreshed = false;
    private boolean sender = true;
    private int power = 0;
    private int frequency = 0;
    private int senderRange = 24;
    private boolean protectedSignal = false;
    private boolean sendExactPower = true;
    private boolean receiveInvertedPower = false;
    private boolean highlightConnections = false;
    private float dishRotationDegrees = 0.0f;
    private float oDishRotationDegrees = 0.0f;
    private boolean changed = false;
    private boolean updateNeighbors = false;

    public SecureRedstoneInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide) {
            Collection<ServerPlayer> players;
            if (!this.tracked) {
                if (!this.isSender()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SecureRedstoneInterfaceBlock.SENDER, (Comparable)Boolean.valueOf(false)));
                }
                this.refreshPower();
                BlockEntityTracker.SECURE_REDSTONE_INTERFACE.track(this);
                this.tracked = true;
            } else if (!this.refreshed) {
                this.refreshed = true;
                if (this.isSender()) {
                    this.tellSimilarReceiversToRefresh();
                }
            }
            if (this.changed) {
                level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
                this.changed = false;
            }
            if (this.updateNeighbors) {
                BlockUtils.updateIndirectNeighbors(level, this.worldPosition, this.getBlockState().getBlock(), ((Direction)this.getBlockState().getValue(SecureRedstoneInterfaceBlock.FACING)).getOpposite());
                this.updateNeighbors = false;
            }
            if (this.shouldHighlightConnections() && level.getGameTime() % 5L == 0L && !(players = TeamUtils.getOnlinePlayersFromOwner(level.getServer(), this.getOwner())).isEmpty()) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 myPos = Vec3.atCenterOf((Vec3i)pos);
                if (this.isSender()) {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversISendTo()) {
                        if (be.isDisabled()) continue;
                        Vec3 receiverPos = Vec3.atCenterOf((Vec3i)be.worldPosition);
                        this.showParticleTrail(players, serverLevel, myPos, receiverPos, SENDER_PARTICLE_COLOR);
                    }
                } else {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe()) {
                        Vec3 senderPos = Vec3.atCenterOf((Vec3i)be.worldPosition);
                        Vector3f color = be.getPower() == 0 ? (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL : RECEIVER_PARTICLE_COLOR_NO_SIGNAL) : (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR : RECEIVER_PARTICLE_COLOR);
                        this.showParticleTrail(players, serverLevel, senderPos, myPos, color);
                    }
                }
            }
        } else {
            this.oDishRotationDegrees = this.dishRotationDegrees;
            if (!this.isDisabled()) {
                this.dishRotationDegrees = this.oDishRotationDegrees + 0.05f;
                if (this.dishRotationDegrees >= 360.0f) {
                    this.dishRotationDegrees = 0.0f;
                }
            }
        }
    }

    public void showParticleTrail(Collection<ServerPlayer> players, ServerLevel level, Vec3 senderPos, Vec3 receiverPos, Vector3f color) {
        Vec3 senderToReceiver = receiverPos.subtract(senderPos);
        Vector3f particleDirection = senderToReceiver.normalize().scale((double)0.01f).toVector3f();
        double step = senderToReceiver.length() * 6.0;
        int i = 0;
        while ((double)i < step) {
            Vec3 particlePos = receiverPos.lerp(senderPos, (double)i / step);
            for (ServerPlayer player : players) {
                level.sendParticles(player, (ParticleOptions)new InterfaceHighlightParticleOptions(color, particleDirection, 1.0f), false, true, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ++i;
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide) {
            BlockEntityTracker.SECURE_REDSTONE_INTERFACE.stopTracking(this);
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
        if (this.isSender()) {
            int currentFrequency = this.getFrequency();
            int range = this.getSenderRange();
            this.tellSimilarReceiversToRefresh(oldOwner, currentFrequency, range);
        } else {
            this.setPower(0);
        }
    }

    @Override
    public boolean needsValidation() {
        return true;
    }

    @Override
    public void onValidate() {
        this.refreshPower();
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled) {
            if (this.isDisabled()) {
                this.setPower(0);
            } else {
                this.refreshPower();
            }
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.sender = tag.getBoolean("sender");
        this.power = tag.getInt("power");
        this.frequency = tag.getInt("frequency");
        this.senderRange = tag.getInt("sender_range");
        this.protectedSignal = tag.getBoolean("protected_signal");
        this.sendExactPower = tag.getBoolean("send_exact_power");
        this.receiveInvertedPower = tag.getBoolean("receive_inverted_power");
        this.highlightConnections = tag.getBoolean("highlight_connections");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putBoolean("sender", this.sender);
        tag.putInt("power", this.power);
        tag.putInt("frequency", this.frequency);
        tag.putInt("sender_range", this.senderRange);
        tag.putBoolean("protected_signal", this.protectedSignal);
        tag.putBoolean("send_exact_power", this.sendExactPower);
        tag.putBoolean("receive_inverted_power", this.receiveInvertedPower);
        tag.putBoolean("highlight_connections", this.highlightConnections);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        ClientHandler.refreshModelData(this);
    }

    public boolean isSender() {
        return this.sender;
    }

    public void setSender(boolean sender) {
        if (this.isSender() == sender || !this.getOwner().isValidated()) {
            return;
        }
        this.sender = sender;
        if (!this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecureRedstoneInterfaceBlock.SENDER, (Comparable)Boolean.valueOf(sender)));
            this.setChanged();
            if (!this.isDisabled()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.updateNeighbors();
        }
    }

    public int getPower() {
        return this.power;
    }

    public void refreshPower() {
        this.refreshPower(this.getFrequency());
    }

    public void refreshPower(int frequency) {
        if (this.level.isClientSide || this.isDisabled() || !this.getOwner().isValidated()) {
            return;
        }
        if (this.isSender()) {
            int bestSignal = this.isProtectedSignal() ? (BlockUtils.hasActiveSCBlockNextTo(this.level, this.worldPosition) ? 15 : 0) : this.level.getBestNeighborSignal(this.worldPosition);
            if (this.sendsExactPower()) {
                this.setPower(bestSignal);
            } else {
                this.setPower(bestSignal > 0 ? 15 : 0);
            }
        } else {
            int highestPower = 0;
            boolean protectedSignal = true;
            boolean foundSender = false;
            for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe(frequency)) {
                int ownPower = be.getPower();
                foundSender = true;
                if (ownPower > highestPower) {
                    highestPower = ownPower;
                }
                if (!be.isProtectedSignal()) {
                    protectedSignal = false;
                }
                if (highestPower != 15 || protectedSignal) continue;
                break;
            }
            if (!foundSender) {
                protectedSignal = false;
            }
            if (this.receivesInvertedPower()) {
                highestPower = 15 - highestPower;
            }
            if (this.protectedSignal != protectedSignal) {
                this.protectedSignal = protectedSignal;
                this.updateNeighbors();
            }
            this.setPower(highestPower);
        }
    }

    public void setPower(int power) {
        if (this.getPower() == power) {
            return;
        }
        this.power = power;
        if (!this.level.isClientSide) {
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.setChanged();
            this.updateNeighbors();
        }
    }

    public int getRedstonePowerOutput() {
        if (!this.isSender() && !this.isDisabled()) {
            return this.getPower();
        }
        return 0;
    }

    public boolean isProtectedSignal() {
        return this.protectedSignal;
    }

    public void setProtectedSignal(boolean protectedSignal) {
        if (this.isProtectedSignal() == protectedSignal || !this.getOwner().isValidated()) {
            return;
        }
        this.protectedSignal = protectedSignal;
        if (!this.level.isClientSide) {
            this.refreshPower();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            } else {
                this.updateNeighbors();
            }
            this.setChanged();
        }
    }

    public boolean sendsExactPower() {
        return this.sendExactPower;
    }

    public void setSendExactPower(boolean sendExactPower) {
        if (this.sendsExactPower() == sendExactPower || !this.getOwner().isValidated()) {
            return;
        }
        this.sendExactPower = sendExactPower;
        if (!this.level.isClientSide && this.isSender()) {
            this.refreshPower();
            this.setChanged();
            this.updateNeighbors();
        }
    }

    public boolean receivesInvertedPower() {
        return this.receiveInvertedPower;
    }

    public void setReceiveInvertedPower(boolean receiveInvertedPower) {
        if (this.receivesInvertedPower() == receiveInvertedPower || !this.getOwner().isValidated()) {
            return;
        }
        this.receiveInvertedPower = receiveInvertedPower;
        if (!this.level.isClientSide && !this.isSender()) {
            this.refreshPower();
            this.setChanged();
            this.updateNeighbors();
        }
    }

    public void tellSimilarReceiversToRefresh() {
        this.tellSimilarReceiversToRefresh(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public void tellSimilarReceiversToRefresh(Owner owner, int frequency, int range) {
        if (!this.level.isClientSide && this.getOwner().isValidated()) {
            for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversToSendTo(owner, frequency, range)) {
                be.refreshPower(frequency);
            }
        }
    }

    public void setFrequency(int frequency) {
        int oldFrequency = this.getFrequency();
        if (oldFrequency == frequency || !this.getOwner().isValidated()) {
            return;
        }
        this.frequency = frequency;
        if (!this.level.isClientSide) {
            Owner owner = this.getOwner();
            int range = this.getSenderRange();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh(owner, oldFrequency, range);
                this.tellSimilarReceiversToRefresh(owner, frequency, range);
            } else {
                this.refreshPower();
            }
            this.setChanged();
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isSameFrequency(int frequency) {
        return this.getFrequency() == frequency;
    }

    public void setSenderRange(int senderRange) {
        senderRange = Math.clamp((long)senderRange, 1, 64);
        if (this.getSenderRange() == senderRange || !this.getOwner().isValidated()) {
            return;
        }
        int oldRange = this.senderRange;
        this.senderRange = senderRange;
        if (!this.level.isClientSide && !this.isDisabled() && this.isSender()) {
            Owner owner = this.getOwner();
            int frequency = this.getFrequency();
            this.tellSimilarReceiversToRefresh(owner, frequency, Math.max(oldRange, senderRange));
            this.setChanged();
        }
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversISendTo() {
        return this.getReceiversToSendTo(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversToSendTo(Owner owner, int frequency, int range) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getBlockEntitiesAround(this.level, this.worldPosition, range);
        all.removeIf(be -> be.isSender() || !be.isOwnedBy(owner) || !be.isSameFrequency(frequency));
        return all;
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe() {
        return this.getSendersThatSendToMe(this.getFrequency());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe(int frequency) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getBlockEntitiesInRange(this.level, this.worldPosition);
        all.removeIf(be -> be.isDisabled() || !be.isSender() || !be.isOwnedBy(this.getOwner()) || !be.isSameFrequency(frequency));
        return all;
    }

    public int getSenderRange() {
        return this.senderRange;
    }

    public boolean shouldHighlightConnections() {
        return this.highlightConnections;
    }

    public void setHighlightConnections(boolean highlightConnections) {
        this.highlightConnections = highlightConnections;
        this.setChanged();
    }

    public void updateNeighbors() {
        this.updateNeighbors = true;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    public float getOriginalDishRotationDegrees() {
        return this.oDishRotationDegrees;
    }

    public float getDishRotationDegrees() {
        return this.dishRotationDegrees;
    }

    public void setChanged() {
        this.changed = true;
        super.setChanged();
    }

    @Override
    public ModelData getModelData() {
        return SecureRedstoneInterfaceBlockEntity.getModelDataBuilder(this).with(SecureRedstoneInterfaceBakedModel.POWERED, (Object)(this.power > 0 ? 1 : 0)).build();
    }
}

