/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InventoryScannerFieldBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HORIZONTAL = InventoryScannerBlock.HORIZONTAL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_EW = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HORIZONTAL_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public InventoryScannerFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ctx;
        if (!(collisionContext instanceof EntityCollisionContext) || (ctx = (EntityCollisionContext)collisionContext).getEntity() == null) {
            return Shapes.empty();
        }
        Entity entity = ctx.getEntity();
        Level level = entity.getCommandSenderWorld();
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner != null && connectedScanner.doesFieldSolidify()) {
            Player player;
            if (entity instanceof Player && !connectedScanner.isConsideredInvisible((LivingEntity)(player = (Player)entity))) {
                if (connectedScanner.isAllowed(entity)) {
                    return Shapes.empty();
                }
                List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
                if (!prohibitedItems.isEmpty() && InventoryScannerFieldBlock.checkInventory(player, connectedScanner, prohibitedItems, false)) {
                    return this.getShape(state, (BlockGetter)level, pos, (CollisionContext)ctx);
                }
            } else if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
                if (!prohibitedItems.isEmpty() && InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, prohibitedItems, false)) {
                    return this.getShape(state, (BlockGetter)level, pos, (CollisionContext)ctx);
                }
            }
        }
        return Shapes.empty();
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Player player;
        if (!this.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).intersects(entity.getBoundingBox())) {
            return;
        }
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner == null || connectedScanner.doesFieldSolidify()) {
            return;
        }
        if (entity instanceof Player && !connectedScanner.isConsideredInvisible((LivingEntity)(player = (Player)entity))) {
            if (connectedScanner.isAllowed(entity)) {
                return;
            }
            List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
            if (!prohibitedItems.isEmpty()) {
                InventoryScannerFieldBlock.checkInventory(player, connectedScanner, prohibitedItems, true);
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            List<ItemStack> prohibitedItems = connectedScanner.getAllProhibitedItems();
            if (!prohibitedItems.isEmpty()) {
                InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, prohibitedItems, true);
            }
        }
    }

    public static boolean checkInventory(Player player, InventoryScannerBlockEntity be, List<ItemStack> prohibitedItems, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.isModuleEnabled(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.isModuleEnabled(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction || be.isOwnedBy((Entity)player) && be.ignoresOwner()) {
            return false;
        }
        return InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.getInventory().items, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.getInventory().armor, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.getInventory().offhand, prohibitedItems, be, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean loopInventory(NonNullList<ItemStack> inventory, List<ItemStack> prohibitedItems, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        boolean itemFound = false;
        block0: for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stackToCheck = (ItemStack)inventory.get(i);
            if (stackToCheck.isEmpty()) continue;
            for (ItemStack prohibitedItem : prohibitedItems) {
                if (InventoryScannerFieldBlock.areItemsEqual(stackToCheck, prohibitedItem, hasSmartModule)) {
                    if (hasStorageModule) {
                        ItemStack remainder = be.addItemToStorage((ItemStack)inventory.get(i));
                        if (!remainder.isEmpty()) {
                            Block.popResource((Level)be.getLevel(), (BlockPos)be.getBlockPos(), (ItemStack)remainder.copy());
                        }
                        inventory.set(i, (Object)ItemStack.EMPTY);
                    }
                    if (hasRedstoneModule) {
                        InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                    }
                    itemFound = true;
                    continue block0;
                }
                if (!InventoryScannerFieldBlock.checkForContainer(stackToCheck, prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule) && !InventoryScannerFieldBlock.checkForBundle(stackToCheck, prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
                itemFound = true;
                continue block0;
            }
        }
        return itemFound;
    }

    public static boolean checkItemEntity(ItemEntity entity, InventoryScannerBlockEntity be, List<ItemStack> prohibitedItems, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.isModuleEnabled(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.isModuleEnabled(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction) {
            return false;
        }
        for (ItemStack prohibitedItem : prohibitedItems) {
            if (InventoryScannerFieldBlock.areItemsEqual(entity.getItem(), prohibitedItem, hasSmartModule)) {
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(entity.getItem());
                    if (!remainder.isEmpty()) {
                        Block.popResource((Level)be.getLevel(), (BlockPos)be.getBlockPos(), (ItemStack)remainder.copy());
                    }
                    entity.discard();
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
            if (!InventoryScannerFieldBlock.checkForContainer(entity.getItem(), prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule) && !InventoryScannerFieldBlock.checkForBundle(entity.getItem(), prohibitedItem, be, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForContainer(ItemStack item, ItemStack stackToCheck, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && item.has(DataComponents.CONTAINER)) {
            ItemContainerContents contents = (ItemContainerContents)item.get(DataComponents.CONTAINER);
            NonNullList list = NonNullList.withSize((int)contents.getSlots(), (Object)ItemStack.EMPTY);
            contents.copyInto(list);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = (ItemStack)list.get(i);
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(itemInChest);
                    if (!remainder.isEmpty()) {
                        Block.popResource((Level)be.getLevel(), (BlockPos)be.getBlockPos(), (ItemStack)remainder.copy());
                    }
                    list.set(i, (Object)ItemStack.EMPTY);
                    item.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)list));
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkForBundle(ItemStack item, ItemStack stackToCheck, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && item.has(DataComponents.BUNDLE_CONTENTS)) {
            List items = ((BundleContents)item.get(DataComponents.BUNDLE_CONTENTS)).itemCopyStream().collect(Collectors.toList());
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemInChest = (ItemStack)items.get(i);
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    ItemStack remainder = be.addItemToStorage(itemInChest);
                    if (!remainder.isEmpty()) {
                        Block.popResource((Level)be.getLevel(), (BlockPos)be.getBlockPos(), (ItemStack)remainder.copy());
                    }
                    items.remove(i);
                    item.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(items));
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack firstItemStack, ItemStack secondItemStack, boolean hasSmartModule) {
        return hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(firstItemStack, secondItemStack) && ItemStack.isSameItemSameComponents((ItemStack)firstItemStack, (ItemStack)secondItemStack) || !hasSmartModule && firstItemStack.getItem() == secondItemStack.getItem();
    }

    private static void updateInventoryScannerPower(InventoryScannerBlockEntity be) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(be.getLevel(), be.getBlockPos());
        if (connectedScanner == null) {
            return;
        }
        be.togglePowerOutput();
        connectedScanner.togglePowerOutput();
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.copy();
        ItemStack s2 = stack2.copy();
        s1.setCount(1);
        s2.setCount(1);
        return ItemStack.matches((ItemStack)s1, (ItemStack)s2);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            Direction facing = (Direction)state.getValue(FACING);
            BlockUtils.removeInSequence((direction, stateToCheck) -> {
                if (stateToCheck.getBlock() != SCContent.INVENTORY_SCANNER_FIELD.get()) {
                    return false;
                }
                Direction stateToCheckFacing = (Direction)stateToCheck.getValue(FACING);
                return stateToCheckFacing == direction || stateToCheckFacing == direction.getOpposite();
            }, level, pos, facing, facing.getOpposite());
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (((Boolean)state.getValue((Property)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        Direction facing = (Direction)state.getValue(FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_EW;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NS;
        }
        return Shapes.block();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HORIZONTAL, WATERLOGGED});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return ItemStack.EMPTY;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && state.getBlock() == adjacentBlockState.getBlock()) {
            return true;
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

