/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.blockentities.BouncingBettyBlockEntity;
import net.geforcemods.securitycraft.blockentities.MineBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BouncingBettyBlock
extends ExplosiveBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.create((String)"deactivated");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);

    public BouncingBettyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (level.getBlockState(pos.below()).isAir()) {
            if (((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue()) {
                level.destroyBlock(pos, true);
            } else {
                this.explode(level, pos);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            MineBlockEntity mine;
            TargetingMode mode;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).inflate(0.01).intersects(entity.getBoundingBox()) && (mode = (mine = (MineBlockEntity)level.getBlockEntity(pos)).getTargetingMode()).canAttackEntity(livingEntity, mine, e -> false)) {
                this.explode(level, pos);
            }
        }
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        MineBlockEntity mine;
        if (!(player.isCreative() || !(mine = (MineBlockEntity)level.getBlockEntity(pos)).getTargetingMode().allowsPlayers() || mine.isOwnedBy((Entity)player) && mine.ignoresOwner())) {
            this.explode(level, pos);
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (level.isClientSide || ((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue()) {
            return;
        }
        BouncingBetty bouncingBettyEntity = new BouncingBetty(level, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
        level.destroyBlock(pos, false);
        bouncingBettyEntity.setFuse(15);
        bouncingBettyEntity.setDeltaMovement(bouncingBettyEntity.getDeltaMovement().multiply(1.0, 0.0, 1.0).add(0.0, 0.5, 0.0));
        LevelUtils.addScheduledTask((LevelAccessor)level, () -> level.addFreshEntity((Entity)bouncingBettyEntity));
        bouncingBettyEntity.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.0f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DEACTIVATED, WATERLOGGED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BouncingBettyBlockEntity(pos, state);
    }
}

