/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IBlockMine;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.CreakingHeartMineBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class CreakingHeartMineBlock
extends CreakingHeartBlock
implements IBlockMine,
IExplosive,
IOverlayDisplay {
    private final Block blockDisguisedAs;

    public CreakingHeartMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties);
        this.blockDisguisedAs = disguisedBlock;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public InteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.exUseItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.exUseWithoutItem(state, level, pos, player, hit);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        block2: {
            block4: {
                block3: {
                    OwnableEntity ownableEntity;
                    Player player;
                    EntityCollisionContext ctx;
                    if (!(collisionContext instanceof EntityCollisionContext) || (ctx = (EntityCollisionContext)collisionContext).getEntity() == null) break block2;
                    Entity entity = ctx.getEntity();
                    if (entity instanceof ItemEntity) break block3;
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (!(blockEntity instanceof IOwnable)) break block4;
                    IOwnable ownable = (IOwnable)blockEntity;
                    if ((!(entity instanceof Player) || !ownable.isOwnedBy((Entity)(player = (Player)entity)) && !player.isCreative()) && (!(entity instanceof OwnableEntity) || !ownable.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity))) break block4;
                }
                return Shapes.block();
            }
            return Shapes.empty();
        }
        return Shapes.block();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        IOwnable ownable;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IOwnable && !(ownable = (IOwnable)blockEntity).isOwnedBy(entity)) {
            this.explode(level, pos);
        }
    }

    public void wasExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
        if (pos.equals((Object)BlockPos.containing((Position)explosion.center()))) {
            return;
        }
        this.explode((Level)level, pos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide) {
            IOwnable ownable;
            if (player != null && player.isCreative() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof IOwnable) || !(ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player)) {
                this.explode(level, pos);
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            level.destroyBlock(pos, false);
            level.explode(null, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 2.5f : 5.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide && (Boolean)state.getValue((Property)ACTIVE) != false ? CreakingHeartMineBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.CREAKING_HEART_MINE_BLOCK_ENTITY.get()), CreakingHeartBlockEntity::serverTick) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CreakingHeartMineBlockEntity(pos, state);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return new ItemStack((ItemLike)this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return false;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        if (IDisguisable.shouldPickBlockDisguise((BlockGetter)level, pos, player)) {
            return new ItemStack((ItemLike)this.blockDisguisedAs);
        }
        return super.getCloneItemStack(level, pos, state, includeData, player);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return this.getBlockDisguisedAs().defaultBlockState();
    }

    @Override
    public Block getBlockDisguisedAs() {
        return this.blockDisguisedAs;
    }
}

