/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.BiConsumer;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedButtonBlock
extends ButtonBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;
    private final float destroyTimeForOwner;

    public ReinforcedButtonBlock(BlockBehaviour.Properties properties, Block vb, BlockSetType blockSetType, int ticksToStayPressed) {
        super(blockSetType, ticksToStayPressed, OwnableBlock.withReinforcedDestroyTime(properties));
        this.vanillaBlock = vb;
        this.destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();
        CommonDoorActivator.addActivator((Block)this);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    protected void onExplosionHit(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (!explosion.canTriggerBlocks()) {
            super.onExplosionHit(state, level, pos, explosion, dropConsumer);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult rayTrace) {
        if (this.isAllowedToPress((AllowlistOnlyBlockEntity)level.getBlockEntity(pos), player)) {
            return super.useWithoutItem(state, level, pos, player, rayTrace);
        }
        return InteractionResult.FAIL;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity;
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!isMoving && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                level.updateNeighborsAt(pos, (Block)this);
                level.updateNeighborsAt(pos.relative(ReinforcedButtonBlock.getConnectedDirection((BlockState)state).getOpposite()), (Block)this);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean isAllowedToPress(AllowlistOnlyBlockEntity be, Player entity) {
        return be.isOwnedBy((Entity)entity) || be.isAllowed((Entity)entity);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AllowlistOnlyBlockEntity(pos, state);
    }
}

