/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.world.phys.AABB;

public class CameraFeed {
    private final Set<BlockPos> linkedFrames = new HashSet<BlockPos>();
    private final AtomicDouble lastActiveTime = new AtomicDouble();
    private final List<SectionRenderDispatcher.RenderSection> sectionsInRange = new ArrayList<SectionRenderDispatcher.RenderSection>();
    private final Set<Long> sectionsInRangePositions = new HashSet<Long>();
    private final List<SectionRenderDispatcher.RenderSection> visibleSections = new ArrayList<SectionRenderDispatcher.RenderSection>();
    private final List<SectionRenderDispatcher.RenderSection> compilingSectionsQueue = new ArrayList<SectionRenderDispatcher.RenderSection>();
    private final RenderTarget renderTarget;
    private boolean requiresFrustumUpdate = false;

    public CameraFeed(GlobalPos globalPos, SectionRenderDispatcher.RenderSection startingSection) {
        int resolution = (Integer)ConfigHandler.CLIENT.frameFeedResolution.get();
        this.renderTarget = new TextureTarget(resolution, resolution, true);
        this.compilingSectionsQueue.add(startingSection);
        this.sectionsInRange.add(startingSection);
        this.sectionsInRangePositions.add(startingSection.getOrigin().asLong());
        this.discoverVisibleSections(globalPos, FrameFeedHandler.getFrameFeedViewDistance(null));
    }

    public void requestFrustumUpdate() {
        this.requiresFrustumUpdate = true;
    }

    public boolean requiresFrustumUpdate() {
        return this.requiresFrustumUpdate;
    }

    public void discoverVisibleSections(GlobalPos cameraPos, int viewDistance) {
        SectionPos cameraSectionPos = SectionPos.of((BlockPos)cameraPos.pos());
        ArrayDeque<SectionRenderDispatcher.RenderSection> queueToCheck = new ArrayDeque<SectionRenderDispatcher.RenderSection>(this.compilingSectionsQueue);
        this.compilingSectionsQueue.clear();
        while (!queueToCheck.isEmpty()) {
            SectionRenderDispatcher.RenderSection currentSection = (SectionRenderDispatcher.RenderSection)queueToCheck.poll();
            BlockPos origin = currentSection.getOrigin();
            SectionRenderDispatcher.CompiledSection currentCompiledSection = currentSection.getCompiled();
            if (currentCompiledSection == SectionRenderDispatcher.CompiledSection.UNCOMPILED) {
                this.compilingSectionsQueue.add(currentSection);
                continue;
            }
            for (Direction dir : Direction.values()) {
                long neighbourPosAsLong;
                SectionRenderDispatcher.RenderSection neighbourSection;
                int cx = SectionPos.blockToSectionCoord((int)origin.getX()) + dir.getStepX();
                int cy = SectionPos.blockToSectionCoord((int)origin.getY()) + dir.getStepY();
                int cz = SectionPos.blockToSectionCoord((int)origin.getZ()) + dir.getStepZ();
                if (!ChunkTrackingView.isInViewDistance((int)cameraSectionPos.x(), (int)cameraSectionPos.z(), (int)viewDistance, (int)cx, (int)cz) || (neighbourSection = CameraViewAreaExtension.rawFetch(cx, cy, cz, true)) == null || this.sectionsInRangePositions.contains(neighbourPosAsLong = neighbourSection.getOrigin().asLong()) || !this.canSeeNeighborFace(currentCompiledSection, dir)) continue;
                this.sectionsInRange.add(neighbourSection);
                this.sectionsInRangePositions.add(neighbourSection.getOrigin().asLong());
                this.compilingSectionsQueue.add(neighbourSection);
                this.requestFrustumUpdate();
            }
        }
    }

    private boolean canSeeNeighborFace(SectionRenderDispatcher.CompiledSection currentCompiledSection, Direction dir) {
        for (int j = 0; j < Direction.values().length; ++j) {
            if (!currentCompiledSection.facesCanSeeEachother(Direction.values()[j].getOpposite(), dir)) continue;
            return true;
        }
        return false;
    }

    public void updateVisibleSections(Frustum frustum) {
        this.requiresFrustumUpdate = false;
        this.visibleSections.clear();
        for (SectionRenderDispatcher.RenderSection section : this.sectionsInRange) {
            if (!frustum.isVisible(section.getBoundingBox())) continue;
            this.visibleSections.add(section);
        }
    }

    public void applyVisibleSections(List<SectionRenderDispatcher.RenderSection> currentVisibleSections) {
        currentVisibleSections.clear();
        currentVisibleSections.addAll(this.visibleSections);
    }

    public boolean hasVisibleSections() {
        return !this.visibleSections.isEmpty();
    }

    public boolean hasFrameInFrustum(Frustum frustum) {
        for (BlockPos framePos : this.linkedFrames) {
            if (!frustum.isVisible(new AABB(framePos))) continue;
            return true;
        }
        return false;
    }

    public void linkFrame(FrameBlockEntity be) {
        this.linkedFrames.add(be.getBlockPos());
    }

    public void unlinkFrame(FrameBlockEntity be) {
        this.linkedFrames.remove(be.getBlockPos());
    }

    public boolean isFrameLinked(FrameBlockEntity be) {
        return this.linkedFrames.contains(be.getBlockPos());
    }

    public void markForRemoval() {
        this.linkedFrames.clear();
    }

    public boolean shouldBeRemoved() {
        return this.linkedFrames.isEmpty();
    }

    public AtomicDouble lastActiveTime() {
        return this.lastActiveTime;
    }

    public RenderTarget renderTarget() {
        return this.renderTarget;
    }
}

