/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class CodebreakerItem
extends Item {
    private static final Component DISABLED = Component.translatable((String)"tooltip.securitycraft.component.success_chance.disabled").withStyle(ChatFormatting.RED);

    public CodebreakerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack briefcase;
        ItemStack codebreaker = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && (briefcase = player.getOffhandItem()).is((Item)SCContent.BRIEFCASE.get())) {
            if (BriefcaseItem.isOwnedBy(briefcase, player) && !player.isCreative()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
            } else {
                double chance = CodebreakerItem.getSuccessChance(codebreaker);
                if (chance < 0.0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
                } else {
                    codebreaker.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    if (!level.isClientSide) {
                        if (!player.isCreative() && ((CodebreakerData)codebreaker.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT)).wasRecentlyUsed()) {
                            return InteractionResult.PASS;
                        }
                        boolean isSuccessful = player.isCreative() || SecurityCraft.RANDOM.nextDouble() < chance;
                        codebreaker.set(SCContent.CODEBREAKER_DATA, (Object)new CodebreakerData(System.currentTimeMillis(), isSuccessful));
                        if (isSuccessful) {
                            player.openMenu(new MenuProvider(){

                                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                                    return new BriefcaseMenu(windowId, inv, ItemContainer.briefcase(briefcase));
                                }

                                public Component getDisplayName() {
                                    return briefcase.getHoverName();
                                }
                            });
                        } else {
                            PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getDescriptionId()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        double chance = CodebreakerItem.getSuccessChance(stack) * 100.0;
        if (chance < 0.0) {
            list.add(DISABLED);
        } else {
            list.add((Component)Component.translatable((String)"tooltip.securitycraft.component.success_chance", (Object[])new Object[]{chance + "%"}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public static double getSuccessChance(ItemStack codebreaker) {
        return (Double)codebreaker.getOrDefault(SCContent.SUCCESS_CHANCE, (Object)1.0);
    }
}

