/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.components.ListModuleData;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ModuleItem
extends Item {
    private static final MutableComponent MODIFIABLE = Component.translatable((String)"tooltip.securitycraft:module.modifiable").setStyle(Utils.GRAY_STYLE);
    private static final MutableComponent NOT_MODIFIABLE = Component.translatable((String)"tooltip.securitycraft:module.notModifiable").setStyle(Utils.GRAY_STYLE);
    private final ModuleType module;
    private final boolean containsCustomData;
    private final boolean canBeCustomized;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData) {
        this(properties, module, containsCustomData, false);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData, boolean canBeCustomized) {
        super(properties);
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory inv = (IModuleInventory)blockEntity;
            ItemStack stack = ctx.getItemInHand();
            ModuleType type = ((ModuleItem)stack.getItem()).getModuleType();
            if (inv instanceof IOwnable && !(ownable = (IOwnable)((Object)inv)).isOwnedBy((Entity)ctx.getPlayer())) {
                return InteractionResult.PASS;
            }
            if (inv.acceptsModule(type) && !inv.hasModule(type)) {
                inv.insertModule(stack, false);
                if (inv instanceof LinkableBlockEntity) {
                    LinkableBlockEntity linkable = (LinkableBlockEntity)inv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.getItem(), false), linkable);
                }
                if (!ctx.getPlayer().isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult use(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (level.isClientSide) {
                    ClientHandler.displayEditModuleScreen(stack);
                }
                return InteractionResult.CONSUME;
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!level.isClientSide) {
                    player.openMenu(new MenuProvider(){

                        public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                            return new DisguiseModuleMenu(windowId, inv, new ModuleItemContainer(player.getItemInHand(hand)));
                        }

                        public Component getDisplayName() {
                            return Component.translatable((String)ModuleItem.this.getDescriptionId());
                        }
                    });
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        ListModuleData listModuleData;
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add((Component)MODIFIABLE);
        } else {
            list.add((Component)NOT_MODIFIABLE);
        }
        if (this.canBeCustomized() && (addon = ModuleItem.getBlockAddon(stack)) != null) {
            list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.added", Utils.localize(addon.getDescriptionId(), new Object[0])).setStyle(Utils.GRAY_STYLE));
        }
        if (this.containsCustomData && (listModuleData = (ListModuleData)stack.get(SCContent.LIST_MODULE_DATA)) != null) {
            listModuleData.addToTooltip(ctx, list::add, flag);
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public static Block getBlockAddon(ItemStack moduleStack) {
        Item item;
        if (!moduleStack.has(DataComponents.CONTAINER)) {
            return null;
        }
        List stacks = ((ItemContainerContents)moduleStack.get(DataComponents.CONTAINER)).nonEmptyStream().toList();
        if (!stacks.isEmpty() && (item = ((ItemStack)stacks.getFirst()).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock();
        }
        return null;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

