/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class LayerToggleHandler {
    private static final List<ResourceLocation> DISABLED_LAYERS = new ArrayList<ResourceLocation>();

    private LayerToggleHandler() {
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiLayerEvent.Pre event) {
        if (LayerToggleHandler.isDisabled(event.getName())) {
            event.setCanceled(true);
        }
    }

    public static boolean isDisabled(ResourceLocation layer) {
        return DISABLED_LAYERS.contains(layer);
    }

    public static void enable(ResourceLocation layer) {
        DISABLED_LAYERS.remove(layer);
    }

    public static void disable(ResourceLocation layer) {
        if (!LayerToggleHandler.isDisabled(layer)) {
            DISABLED_LAYERS.add(layer);
        }
    }
}

