/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforgespi.language.IModInfo;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class Tips {
    public static final Map<String, String> TIPS_WITH_LINK = new HashMap<String, String>();

    private Tips() {
    }

    @SubscribeEvent
    public static void onLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        if (!((Boolean)ConfigHandler.SERVER.disableThanksMessage.get()).booleanValue() && ((Boolean)ConfigHandler.CLIENT.sayThanksMessage.get()).booleanValue()) {
            String tipKey = Tips.getRandomTip();
            MutableComponent message = Component.literal((String)"[").append((Component)Component.literal((String)"SecurityCraft").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"] ")).append((Component)Utils.localize("messages.securitycraft:thanks", SecurityCraft.getVersion(), Utils.localize("messages.securitycraft:tip", new Object[0]), Utils.localize(tipKey, new Object[0])));
            if (TIPS_WITH_LINK.containsKey(tipKey.split("\\.")[2])) {
                message = message.append(CommonHooks.newChatWithLinks((String)TIPS_WITH_LINK.get(tipKey.split("\\.")[2])));
            }
            ClientHandler.getClientPlayer().displayClientMessage((Component)message, false);
        }
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver", "messages.securitycraft:tip.outdated"};
        return tips[SecurityCraft.RANDOM.nextInt(Tips.isOutdated() ? tips.length : tips.length - 1)];
    }

    private static boolean isOutdated() {
        return VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("securitycraft").get()).getModInfo()).status() == VersionChecker.Status.OUTDATED;
    }

    static {
        TIPS_WITH_LINK.put("patreon", "https://www.patreon.com/Geforce");
        TIPS_WITH_LINK.put("discord", "https://discord.gg/U8DvBAW");
        TIPS_WITH_LINK.put("outdated", "https://www.curseforge.com/minecraft/mc-mods/security-craft/files/all");
    }
}

