/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class DisguisableDynamicBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<BlockState> DISGUISED_STATE = new ModelProperty();
    private final BakedModel oldModel;

    public DisguisableDynamicBakedModel(BakedModel oldModel) {
        this.oldModel = oldModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        BakedModel model;
        Block block;
        BlockState disguisedState = (BlockState)modelData.get(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.getBlock()) != Blocks.AIR && (model = Minecraft.getInstance().getBlockRenderer().getBlockModel(disguisedState)) != null && model != this) {
            return model.getQuads(disguisedState, side, rand, modelData, renderType);
        }
        return this.getOldQuads(state, side, rand, modelData, renderType);
    }

    public List<BakedQuad> getOldQuads(BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        return this.oldModel.getQuads(state, side, rand, modelData, renderType);
    }

    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        BakedModel model;
        Block block;
        BlockState disguisedState = (BlockState)modelData.get(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.getBlock()) != Blocks.AIR && (model = Minecraft.getInstance().getBlockRenderer().getBlockModel(disguisedState)) != null && model != this) {
            return model.getParticleIcon(modelData);
        }
        return this.getOldParticleIcon(modelData);
    }

    public TextureAtlasSprite getOldParticleIcon(ModelData modelData) {
        return this.oldModel.getParticleIcon(modelData);
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.oldModel.getParticleIcon();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData modelData) {
        BakedModel model;
        Block block;
        BlockState disguisedState = (BlockState)modelData.get(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.getBlock()) != Blocks.AIR && (model = Minecraft.getInstance().getBlockRenderer().getBlockModel(disguisedState)) != null && model != this) {
            return model.getRenderTypes(disguisedState, rand, ModelData.EMPTY);
        }
        return this.getOldRenderTypes(state, rand, modelData);
    }

    public ChunkRenderTypeSet getOldRenderTypes(BlockState state, RandomSource rand, ModelData modelData) {
        return this.oldModel.getRenderTypes(state, rand, modelData);
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public ItemTransforms getTransforms() {
        return this.oldModel.getTransforms();
    }
}

