/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.geforcemods.securitycraft.SCStreamCodecs;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link, Optional<String> usableBy) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncKeycardSettings> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_keycard_settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncKeycardSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncKeycardSettings::pos, SCStreamCodecs.BOOLEAN_ARRAY, SyncKeycardSettings::acceptedLevels, (StreamCodec)ByteBufCodecs.VAR_INT, SyncKeycardSettings::signature, (StreamCodec)ByteBufCodecs.BOOL, SyncKeycardSettings::link, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), SyncKeycardSettings::usableBy, SyncKeycardSettings::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        KeycardReaderBlockEntity be;
        boolean isOwner;
        BlockEntity blockEntity;
        Player player = ctx.player();
        if (!player.isSpectator() && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof KeycardReaderBlockEntity && ((isOwner = (be = (KeycardReaderBlockEntity)blockEntity).isOwnedBy((Entity)player)) || be.isAllowed((Entity)player))) {
            AbstractContainerMenu abstractContainerMenu;
            if (isOwner) {
                be.setAcceptedLevels(this.acceptedLevels);
                be.setSignature(this.signature);
            }
            if (this.link && (abstractContainerMenu = player.containerMenu) instanceof KeycardReaderMenu) {
                KeycardReaderMenu keycardReaderContainer = (KeycardReaderMenu)abstractContainerMenu;
                keycardReaderContainer.link(this.usableBy);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SyncKeycardSettings skc = (SyncKeycardSettings)obj;
        return this.pos != null && this.pos.equals((Object)skc.pos) && Arrays.equals(this.acceptedLevels, skc.acceptedLevels) && this.signature == skc.signature && this.link == skc.link;
    }

    @Override
    public int hashCode() {
        int arrayHash = Arrays.hashCode(this.acceptedLevels);
        return Objects.hash(this.pos, arrayHash, this.signature, this.link);
    }

    @Override
    public String toString() {
        return "SyncKeycardSettings{pos=" + String.valueOf(this.pos) + ", acceptedLevels=" + Arrays.toString(this.acceptedLevels) + ", signature=" + this.signature + ", link=" + this.link + "}";
    }
}

