/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncProjector(BlockPos pos, int data, DataType dataType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncProjector> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_projector"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncProjector> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncProjector>(){

        public SyncProjector decode(RegistryFriendlyByteBuf buf) {
            BlockPos pos = buf.readBlockPos();
            DataType dataType = (DataType)buf.readEnum(DataType.class);
            if (dataType.isBoolean) {
                return new SyncProjector(pos, buf.readBoolean() ? 1 : 0, dataType);
            }
            return new SyncProjector(pos, buf.readVarInt(), dataType);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncProjector packet) {
            buf.writeBlockPos(packet.pos);
            buf.writeEnum((Enum)packet.dataType);
            if (packet.dataType.isBoolean) {
                buf.writeBoolean(packet.data == 1);
            } else {
                buf.writeVarInt(packet.data);
            }
        }
    };

    public SyncProjector(BlockPos pos, BlockState state) {
        this(pos, Block.getId((BlockState)state), DataType.BLOCK_STATE);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        if (!player.isSpectator() && level.isLoaded(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            switch (this.dataType.ordinal()) {
                case 0: {
                    be.setProjectionWidth(this.data);
                    break;
                }
                case 1: {
                    be.setProjectionHeight(this.data);
                    break;
                }
                case 2: {
                    be.setProjectionRange(this.data);
                    break;
                }
                case 3: {
                    be.setProjectionOffset(this.data);
                    break;
                }
                case 4: {
                    be.setHorizontal(this.data == 1);
                    break;
                }
                case 5: {
                    be.setOverridingBlocks(this.data == 1);
                    break;
                }
                case 6: {
                    be.setProjectedState(Block.stateById((int)this.data));
                    break;
                }
                case 7: {
                    throw new UnsupportedOperationException("Invalid sync projector payload received!");
                }
            }
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL(true),
        OVERRIDING_BLOCKS(true),
        BLOCK_STATE,
        INVALID;

        public final boolean isBoolean;

        private DataType() {
            this(false);
        }

        private DataType(boolean isBoolean) {
            this.isBoolean = isBoolean;
        }
    }
}

