/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncSecureRedstoneInterface(BlockPos pos, boolean sender, boolean protectedSignal, int frequency, boolean sendExactPower, boolean receiveInvertedPower, int senderRange, boolean highlightConnections) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncSecureRedstoneInterface> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_secure_redstone_interface"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncSecureRedstoneInterface> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncSecureRedstoneInterface>(){

        public void encode(RegistryFriendlyByteBuf buf, SyncSecureRedstoneInterface packet) {
            buf.writeBlockPos(packet.pos);
            buf.writeBoolean(packet.sender);
            buf.writeBoolean(packet.protectedSignal);
            buf.writeVarInt(packet.frequency);
            buf.writeBoolean(packet.sendExactPower);
            buf.writeBoolean(packet.receiveInvertedPower);
            buf.writeVarInt(packet.senderRange);
            buf.writeBoolean(packet.highlightConnections);
        }

        public SyncSecureRedstoneInterface decode(RegistryFriendlyByteBuf buf) {
            return new SyncSecureRedstoneInterface(buf.readBlockPos(), buf.readBoolean(), buf.readBoolean(), buf.readVarInt(), buf.readBoolean(), buf.readBoolean(), buf.readVarInt(), buf.readBoolean());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (this.sender != be.isSender()) {
                be.setSender(this.sender);
            }
            if (this.protectedSignal != be.isProtectedSignal()) {
                be.setProtectedSignal(this.protectedSignal);
            }
            if (this.frequency != be.getFrequency()) {
                be.setFrequency(this.frequency);
            }
            if (this.sendExactPower != be.sendsExactPower()) {
                be.setSendExactPower(this.sendExactPower);
            }
            if (this.receiveInvertedPower != be.receivesInvertedPower()) {
                be.setReceiveInvertedPower(this.receiveInvertedPower);
            }
            if (this.senderRange != be.getSenderRange()) {
                be.setSenderRange(this.senderRange);
            }
            be.setHighlightConnections(this.highlightConnections);
        }
    }
}

