/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.mines.BouncingBettyBlock;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class BouncingBettyRenderer
extends EntityRenderer<BouncingBetty, BouncingBettyRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public BouncingBettyRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.shadowRadius = 0.5f;
        this.blockRenderer = ctx.getBlockRenderDispatcher();
    }

    public void render(BouncingBettyRenderState state, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        pose.pushPose();
        pose.translate(0.0f, 0.5f, 0.0f);
        if (state.fuseRemainingInTicks < 10.0f) {
            float scale = 1.0f - state.fuseRemainingInTicks / 10.0f;
            scale = Mth.clamp((float)scale, (float)0.0f, (float)1.0f);
            scale *= scale;
            scale *= scale;
            scale = 1.0f + scale * 0.3f;
            pose.scale(scale, scale, scale);
        }
        pose.mulPose(Axis.YP.rotationDegrees(-90.0f));
        pose.translate(-0.5f, -0.5f, 0.5f);
        pose.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)((BouncingBettyBlock)SCContent.BOUNCING_BETTY.get()).defaultBlockState(), (PoseStack)pose, (MultiBufferSource)buffer, (int)packedLight, (state.fuseRemainingInTicks / 5.0f % 2.0f == 0.0f ? 1 : 0) != 0);
        pose.popPose();
        super.render((EntityRenderState)state, pose, buffer, packedLight);
    }

    public BouncingBettyRenderState createRenderState() {
        return new BouncingBettyRenderState();
    }

    public void extractRenderState(BouncingBetty entity, BouncingBettyRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.fuseRemainingInTicks = (float)entity.getFuse() - partialTicks + 1.0f;
    }
}

