/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.renderers.SentryRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SentryRenderer
extends EntityRenderer<Sentry, SentryRenderState> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/entity/sentry.png");
    private final SentryModel model;

    public SentryRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new SentryModel(ctx.bakeLayer(ClientHandler.SENTRY_LOCATION));
    }

    public void render(SentryRenderState state, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        VertexConsumer builder = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        float scale = state.scale;
        pose.pushPose();
        pose.scale(scale, scale, scale);
        pose.translate(0.0, 1.5, 0.0);
        pose.scale(-1.0f, -1.0f, 1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.model.renderBase(pose, builder, packedLight, OverlayTexture.NO_OVERLAY, -1);
        pose.mulPose(Axis.YP.rotationDegrees(state.headRotation));
        pose.translate(0.0f, state.headY, 0.0f);
        this.model.renderHead(pose, builder, packedLight, OverlayTexture.NO_OVERLAY, -1);
        pose.popPose();
    }

    public SentryRenderState createRenderState() {
        return new SentryRenderState();
    }

    public void extractRenderState(Sentry sentry, SentryRenderState state, float partialTicks) {
        super.extractRenderState((Entity)sentry, (EntityRenderState)state, partialTicks);
        state.headRotation = Mth.lerp((float)partialTicks, (float)sentry.getOriginalHeadRotation(), (float)sentry.getHeadRotation());
        state.headY = sentry.getHeadYTranslation(partialTicks);
    }
}

