/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AlarmOptionsScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = SecurityCraft.resLoc("textures/gui/container/alarm_options.png");
    private static final ResourceLocation RESET_SPRITE = SecurityCraft.resLoc("widget/reset");
    private static final ResourceLocation RESET_INACTIVE_SPRITE = SecurityCraft.resLoc("widget/reset_inactive");
    private final Component soundLengthText = Component.translatable((String)"gui.securitycraft:alarm.sound_length").withStyle(ChatFormatting.UNDERLINE);
    private final AlarmScreen alarmScreen;
    private int imageWidth = 226;
    private int imageHeight = 112;
    private int leftPos;
    private int topPos;
    private Button minusMinute;
    private Button minusTenSeconds;
    private Button minusSecond;
    private Button reset;
    private Button plusSecond;
    private Button plusTenSeconds;
    private Button plusMinute;
    private SoundLengthEditBox soundLengthEditBox;
    private int soundLengthTextXPosition;

    public AlarmOptionsScreen(AlarmScreen alarmScreen) {
        super((Component)Utils.localize("options.title", new Object[0]));
        this.alarmScreen = alarmScreen;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        int buttonHeight = 13;
        int buttonsX = this.leftPos + 5;
        int buttonY = this.topPos + 40;
        int timeEditBoxWidth = 34;
        int soundLengthTextWidthPlusBuffer = this.font.width((FormattedText)this.soundLengthText) + 5;
        int combinedTextAndBoxWidth = soundLengthTextWidthPlusBuffer + timeEditBoxWidth;
        this.addRenderableWidget((GuiEventListener)SmallButton.createWithX(this.leftPos + this.imageWidth - 12, this.topPos + 4, b -> Minecraft.getInstance().popGuiLayer()));
        this.soundLengthTextXPosition = this.width / 2 - combinedTextAndBoxWidth / 2;
        this.soundLengthEditBox = (SoundLengthEditBox)this.addRenderableWidget((GuiEventListener)new SoundLengthEditBox(this.font, this.soundLengthTextXPosition + soundLengthTextWidthPlusBuffer, buttonY - 15, timeEditBoxWidth, 12, (Component)Component.empty()));
        this.soundLengthEditBox.setFilter(string -> string.matches("[0-9:]*"));
        this.minusMinute = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.minus_one_minute"), b -> this.changeSoundLength(-60), Button.DEFAULT_NARRATION));
        this.minusTenSeconds = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX + 34, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.minus_ten_seconds"), b -> this.changeSoundLength(-10), Button.DEFAULT_NARRATION));
        this.minusSecond = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX + 68, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.minus_one_second"), b -> this.changeSoundLength(-1), Button.DEFAULT_NARRATION));
        this.reset = (Button)this.addRenderableWidget((GuiEventListener)new ActiveBasedTextureButton(buttonsX + 102, buttonY, 12, buttonHeight, RESET_SPRITE, RESET_INACTIVE_SPRITE, 1, 2, 10, 10, b -> this.changeSoundLength(0)));
        this.plusSecond = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX + 116, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.plus_one_second"), b -> this.changeSoundLength(1), Button.DEFAULT_NARRATION));
        this.plusTenSeconds = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX + 150, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.plus_ten_seconds"), b -> this.changeSoundLength(10), Button.DEFAULT_NARRATION));
        this.plusMinute = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonsX + 184, buttonY, 32, buttonHeight, (Component)Component.translatable((String)"gui.securitycraft:alarm.plus_one_minute"), b -> this.changeSoundLength(60), Button.DEFAULT_NARRATION));
        this.setSoundLength(this.alarmScreen.soundLength);
        ((CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(this.leftPos + this.imageWidth / 2 - 50, buttonY + 25, 100, 20, (Component)Utils.localize("gui.securitycraft:alarm.pitch", ""), (Component)Component.empty(), 0.5, 2.0, this.alarmScreen.pitch, 0.05, 0, true, slider -> {
            this.alarmScreen.pitch = (float)slider.getValue();
        }))).setFGColor(0xE0E0E0);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.soundLengthText, this.soundLengthTextXPosition, this.topPos + 27, 0x404040, false);
        if (this.alarmScreen.be.isPowered() && !this.alarmScreen.be.isDisabled()) {
            int cooldownSeconds = (this.alarmScreen.be.getCooldown() - 1) / 20;
            MutableComponent nextSoundText = Utils.localize("gui.securitycraft:alarm.nextSound", String.format("%02d:%02d", cooldownSeconds / 60, cooldownSeconds % 60 + 1));
            guiGraphics.drawString(this.font, (Component)nextSoundText, this.width / 2 - this.font.width((FormattedText)nextSoundText) / 2, this.topPos + 95, 0x404040, false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(RenderType::guiTextured, GUI_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void setSoundLength(int newSoundLength) {
        this.setSoundLength(newSoundLength, true);
    }

    public void changeSoundLength(int soundLengthChange) {
        if (soundLengthChange == 0) {
            this.setSoundLength(this.alarmScreen.previousSoundLength, true);
        } else {
            this.setSoundLength(this.alarmScreen.soundLength + soundLengthChange, true);
        }
    }

    public void setSoundLength(int newSoundLength, boolean updateTimeEditBox) {
        boolean enableMinusButtons;
        int soundLength = Math.clamp((long)newSoundLength, 1, 3600);
        if (updateTimeEditBox) {
            this.soundLengthEditBox.setValue(String.format("%02d:%02d", soundLength / 60, soundLength % 60));
        }
        boolean enablePlusButtons = soundLength < 3600;
        this.minusMinute.active = enableMinusButtons = soundLength > 1;
        this.minusTenSeconds.active = enableMinusButtons;
        this.minusSecond.active = enableMinusButtons;
        this.reset.active = soundLength != this.alarmScreen.previousSoundLength;
        this.plusSecond.active = enablePlusButtons;
        this.plusTenSeconds.active = enablePlusButtons;
        this.plusMinute.active = enablePlusButtons;
        this.alarmScreen.soundLength = soundLength;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.soundLengthEditBox.checkAndProcessInput();
        super.onClose();
    }

    public boolean isPauseScreen() {
        return this.alarmScreen.isPauseScreen();
    }

    public class SoundLengthEditBox
    extends EditBox {
        public SoundLengthEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            AlarmOptionsScreen.this.changeSoundLength((int)Math.signum(scrollY));
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 || keyCode == 335) {
                this.checkAndProcessInput();
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void setFocused(boolean focused) {
            if (this.isFocused() && !focused) {
                this.checkAndProcessInput();
            }
            super.setFocused(focused);
        }

        public void checkAndProcessInput() {
            int minutes = 0;
            int seconds = 2;
            if (this.value != null && !this.value.isEmpty() && !this.value.isBlank()) {
                if (!this.value.contains(":")) {
                    int numeric = Integer.parseInt(this.value);
                    minutes = numeric / 60;
                    seconds = numeric % 60;
                } else {
                    String[] split = this.value.split(":");
                    if (split.length == 2) {
                        if (!split[0].isEmpty() && !split[0].isBlank()) {
                            try {
                                minutes = Integer.parseInt(split[0]);
                            }
                            catch (NumberFormatException e) {
                                minutes = 60;
                            }
                        }
                        if (!split[1].isEmpty() && !split[1].isBlank()) {
                            try {
                                seconds = Integer.parseInt(split[1]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            seconds = 0;
                        }
                    }
                }
            }
            AlarmOptionsScreen.this.setSoundLength(minutes * 60 + seconds, true);
            this.moveCursorToEnd(false);
        }
    }
}

