/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.CheckBriefcasePasscode;
import net.geforcemods.securitycraft.network.server.SetBriefcasePasscodeAndOwner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BriefcasePasscodeScreen
extends Screen {
    public static final String UP_ARROW = "\u2191";
    public static final String RIGHT_ARROW = "\u2192";
    public static final String DOWN_ARROW = "\u2193";
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final boolean isSetup;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private EditBox[] keycodeTextboxes = new EditBox[4];
    private int[] digits = new int[]{0, 0, 0, 0};

    public BriefcasePasscodeScreen(Component title, boolean isSetup) {
        super(title);
        this.isSetup = isSetup;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 4; ++i) {
            int id = i;
            this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 40 + i * 20, this.height / 2 - 52, 20, 20, (Component)Component.literal((String)UP_ARROW), b -> this.keycodeButtonClicked(id), Button.DEFAULT_NARRATION));
            this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 40 + i * 20, this.height / 2, 20, 20, (Component)Component.literal((String)DOWN_ARROW), b -> this.keycodeButtonClicked(4 + id), Button.DEFAULT_NARRATION));
            this.keycodeTextboxes[i] = (EditBox)this.addRenderableOnly((Renderable)new EditBox(this.font, this.width / 2 - 37 + i * 20, this.height / 2 - 22, 14, 12, (Component)Component.empty()));
            this.keycodeTextboxes[i].setMaxLength(1);
            this.keycodeTextboxes[i].setValue("0");
        }
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 42, this.height / 2 - 26, 20, 20, (Component)Component.literal((String)RIGHT_ARROW), this::continueButtonClicked, Button.DEFAULT_NARRATION));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void continueButtonClicked(Button button) {
        ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
        if (!briefcase.isEmpty()) {
            String passcode = "" + this.digits[0] + this.digits[1] + this.digits[2] + this.digits[3];
            if (this.isSetup) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetBriefcasePasscodeAndOwner(passcode), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClientHandler.displayBriefcasePasscodeScreen(briefcase.getHoverName());
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new CheckBriefcasePasscode(passcode), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private void keycodeButtonClicked(int id) {
        int n;
        int index = id % 4;
        if (id > 3) {
            int n2 = index;
            n = this.digits[n2] = this.digits[n2] - 1;
        } else {
            int n3 = index;
            n = this.digits[n3] = this.digits[n3] + 1;
        }
        this.digits[index] = Math.floorMod(n, 10);
        this.keycodeTextboxes[index].setValue(String.valueOf(this.digits[index]));
    }
}

