/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class MineRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/mrat.png");
    private static final ResourceLocation EXPLOSIVE_SPRITE = SecurityCraft.resLoc("sc_manual/explosive_highlighted");
    private static final int DEFUSE = 0;
    private static final int ACTIVATE = 1;
    private static final int DETONATE = 2;
    private static final int UNBIND = 3;
    private ItemStack mrat;
    private Button[][] guiButtons = new Button[6][4];
    private int xSize = 256;
    private int ySize = 184;
    private int leftPos;
    private int topPos;
    private final Component notBound = Utils.localize("gui.securitycraft:mrat.notBound", new Object[0]);
    private final Component[] lines = new Component[6];
    private final int[] lengths = new int[6];

    public MineRemoteAccessToolScreen(ItemStack item) {
        super(item.getHoverName());
        this.mrat = item;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        int padding = 25;
        int y = 50;
        int id = 0;
        int startX = (this.width - this.xSize) / 2;
        int startY = (this.height - this.ySize) / 2;
        for (int i = 0; i < 6; ++i) {
            y += 25;
            for (int j = 0; j < 4; ++j) {
                int btnX = startX + j * padding + 154;
                int btnY = startY + y - 48;
                int mine = id / 4;
                int action = id % 4;
                ++id;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, new ItemStack((ItemLike)SCContent.WIRE_CUTTERS.get()), b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, new ItemStack((ItemLike)Items.FLINT_AND_STEEL), b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, EXPLOSIVE_SPRITE, 0, 1, 18, 18, b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 3: {
                        this.guiButtons[i][j] = new Button(btnX, btnY, 20, 20, (Component)Component.literal((String)"X"), b -> this.buttonClicked(mine, action), Button.DEFAULT_NARRATION);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
                    }
                }
                this.guiButtons[i][j].active = false;
                this.addRenderableWidget((GuiEventListener)this.guiButtons[i][j]);
            }
            GlobalPos globalPos = this.getMineCoordinates(i);
            boolean foundMine = false;
            if (globalPos != null) {
                Block block;
                ClientLevel level = this.minecraft.level;
                BlockPos minePos = globalPos.pos();
                this.guiButtons[i][3].active = true;
                this.lines[i] = Utils.localize("gui.securitycraft:mrat.mineLocations", minePos);
                if (globalPos.dimension().equals(level.dimension()) && level.isLoaded(minePos) && (block = level.getBlockState(minePos).getBlock()) instanceof IExplosive) {
                    IOwnable ownable;
                    IExplosive explosive = (IExplosive)block;
                    BlockEntity blockEntity = level.getBlockEntity(minePos);
                    if (!(blockEntity instanceof IOwnable) || (ownable = (IOwnable)blockEntity).isOwnedBy((Entity)this.minecraft.player)) {
                        boolean active = explosive.isActive((Level)level, minePos);
                        boolean defusable = explosive.isDefusable();
                        this.guiButtons[i][0].active = active && defusable;
                        this.guiButtons[i][1].active = !active && defusable;
                        this.guiButtons[i][2].active = active;
                        this.guiButtons[i][0].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.defuse", new Object[0])));
                        this.guiButtons[i][1].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.activate", new Object[0])));
                        this.guiButtons[i][2].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.detonate", new Object[0])));
                        this.guiButtons[i][3].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
                        foundMine = true;
                    }
                }
                if (!foundMine) {
                    for (int j = 0; j < 3; ++j) {
                        this.guiButtons[i][j].active = false;
                        this.guiButtons[i][j].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.outOfRange", new Object[0])));
                    }
                }
                this.guiButtons[i][3].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
            } else {
                this.lines[i] = this.notBound;
            }
            this.lengths[i] = this.font.width((FormattedText)this.lines[i]);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
        for (int i = 0; i < 6; ++i) {
            guiGraphics.drawString(this.font, this.lines[i], this.leftPos + this.xSize / 2 - this.lengths[i] + 25, this.topPos + i * 25 + 33, 0x404040, false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    private void buttonClicked(int mine, int action) {
        GlobalPos globalPos = this.getMineCoordinates(mine);
        if (globalPos != null) {
            BlockPos pos = globalPos.pos();
            switch (action) {
                case 0: {
                    ((IExplosive)Minecraft.getInstance().player.level().getBlockState(pos).getBlock()).defuseMine(Minecraft.getInstance().player.level(), pos);
                    PacketDistributor.sendToServer((CustomPacketPayload)new RemoteControlMine(pos, RemoteControlMine.Action.DEFUSE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.guiButtons[mine][0].active = false;
                    this.guiButtons[mine][1].active = true;
                    this.guiButtons[mine][2].active = false;
                    break;
                }
                case 1: {
                    ((IExplosive)Minecraft.getInstance().player.level().getBlockState(pos).getBlock()).activateMine(Minecraft.getInstance().player.level(), pos);
                    PacketDistributor.sendToServer((CustomPacketPayload)new RemoteControlMine(pos, RemoteControlMine.Action.ACTIVATE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.guiButtons[mine][0].active = true;
                    this.guiButtons[mine][1].active = false;
                    this.guiButtons[mine][2].active = true;
                    break;
                }
                case 2: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new RemoteControlMine(pos, RemoteControlMine.Action.DETONATE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.removeTagFromToolAndUpdate(this.mrat, globalPos);
                    for (int i = 0; i < 4; ++i) {
                        this.guiButtons[mine][i].active = false;
                    }
                    break;
                }
                case 3: {
                    this.removeTagFromToolAndUpdate(this.mrat, globalPos);
                    for (int i = 0; i < 4; ++i) {
                        this.guiButtons[mine][i].active = false;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
                }
            }
        }
    }

    private GlobalPos getMineCoordinates(int mine) {
        GlobalPositions positions;
        if (this.mrat.getItem() == SCContent.MINE_REMOTE_ACCESS_TOOL.get() && (positions = (GlobalPositions)this.mrat.get(SCContent.BOUND_MINES)) != null && mine >= 0 && mine < positions.size()) {
            return positions.positions().get(mine);
        }
        return null;
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, GlobalPos pos) {
        ((GlobalPositions)stack.getOrDefault(SCContent.BOUND_MINES, (Object)GlobalPositions.sized(6))).remove(SCContent.BOUND_MINES, stack, pos);
        PacketDistributor.sendToServer((CustomPacketPayload)new RemoveMineFromMRAT(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

