/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class SecureRedstoneInterfaceScreen
extends Screen {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/secure_redstone_interface.png");
    private static final ResourceLocation RANDOM_SPRITE = SecurityCraft.resLoc("widget/random");
    private static final ResourceLocation RANDOM_INACTIVE_SPRITE = SecurityCraft.resLoc("widget/random_inactive");
    private final Component frequencyText = Component.translatable((String)"gui.securitycraft:secure_redstone_interface.frequency");
    private final SecureRedstoneInterfaceBlockEntity be;
    private final boolean oldSender;
    private final boolean oldProtectedSignal;
    private final boolean oldSendExactPower;
    private final boolean oldReceiveInvertedPower;
    private final boolean oldHighlightConnections;
    private final int oldFrequency;
    private final int oldSenderRange;
    private final int xSize = 176;
    private final int ySize = 188;
    private int leftPos;
    private int topPos;
    private EditBox frequencyBox;

    public SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        this(be, be.isSender(), be.isProtectedSignal(), be.getFrequency(), be.sendsExactPower(), be.receivesInvertedPower(), be.getSenderRange(), be.shouldHighlightConnections());
    }

    private SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be, boolean oldSender, boolean oldProtectedSignal, int oldFrequency, boolean oldSendExactPower, boolean oldReceiveInvertedPower, int oldSenderRange, boolean oldHighlightConnections) {
        super(be.getDisplayName());
        this.be = be;
        this.oldSender = oldSender;
        this.oldProtectedSignal = oldProtectedSignal;
        this.oldFrequency = oldFrequency;
        this.oldSendExactPower = oldSendExactPower;
        this.oldReceiveInvertedPower = oldReceiveInvertedPower;
        this.oldSenderRange = oldSenderRange;
        this.oldHighlightConnections = oldHighlightConnections;
    }

    protected void init() {
        int widgetWidth = 150;
        int widgetHeight = 20;
        super.init();
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 188) / 2;
        LinearLayout layout = new LinearLayout(0, 0, LinearLayout.Orientation.VERTICAL).spacing(3);
        LinearLayout frequencyLayout = new LinearLayout(widgetWidth, widgetHeight, LinearLayout.Orientation.HORIZONTAL).spacing(3);
        String powerSettingKey = "gui.securitycraft:secure_redstone_interface." + (this.be.isSender() ? "send_exact_power" : "receive_inverted_power");
        this.frequencyBox = new EditBox(this.font, widgetWidth - 23, widgetHeight, this.frequencyText);
        this.frequencyBox.setValue("" + this.be.getFrequency());
        this.frequencyBox.setMaxLength(9);
        this.frequencyBox.setFilter(s -> s.matches("\\d*"));
        this.frequencyBox.setResponder(s -> {
            if (!s.isEmpty()) {
                this.be.setFrequency(Integer.parseInt(s));
            } else {
                this.be.setFrequency(0);
            }
        });
        frequencyLayout.addChild((LayoutElement)this.frequencyBox);
        frequencyLayout.addChild((LayoutElement)new ActiveBasedTextureButton(0, 0, 20, widgetHeight, RANDOM_SPRITE, RANDOM_INACTIVE_SPRITE, 3, 3, 16, 16, b -> this.frequencyBox.setValue("" + SecurityCraft.RANDOM.nextInt(999999999))));
        layout.addChild((LayoutElement)frequencyLayout);
        layout.addChild((LayoutElement)CycleButton.builder(value -> Component.translatable((String)("gui.securitycraft:secure_redstone_interface.mode." + (value != false ? "sender" : "receiver")))).withValues((Object[])new Boolean[]{true, false}).withInitialValue((Object)this.be.isSender()).create(0, 0, widgetWidth, widgetHeight, (Component)Component.translatable((String)"gui.securitycraft:secure_redstone_interface.mode"), (button, isNowASender) -> {
            this.be.setSender((boolean)isNowASender);
            if (isNowASender.booleanValue()) {
                this.be.setReceiveInvertedPower(this.oldReceiveInvertedPower);
            } else {
                this.be.setProtectedSignal(this.oldProtectedSignal);
                this.be.setSendExactPower(this.oldSendExactPower);
                this.be.setSenderRange(this.oldSenderRange);
            }
            this.minecraft.setScreen((Screen)new SecureRedstoneInterfaceScreen(this.be, this.oldSender, this.oldProtectedSignal, this.oldFrequency, this.oldSendExactPower, this.oldReceiveInvertedPower, this.oldSenderRange, this.oldHighlightConnections));
        }));
        layout.addChild((LayoutElement)CycleButton.builder(value -> Component.translatable((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).withValues((Object[])new Boolean[]{true, false}).withInitialValue((Object)(this.be.isSender() ? this.be.sendsExactPower() : this.be.receivesInvertedPower())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)(powerSettingKey + ".tooltip." + value)))).create(0, 0, widgetWidth, widgetHeight, (Component)Component.translatable((String)powerSettingKey), (button, newValue) -> {
            if (this.be.isSender()) {
                this.be.setSendExactPower((boolean)newValue);
            } else {
                this.be.setReceiveInvertedPower((boolean)newValue);
            }
        }));
        if (this.be.isSender()) {
            layout.addChild((LayoutElement)CycleButton.builder(value -> Component.translatable((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).withValues((Object[])new Boolean[]{true, false}).withInitialValue((Object)this.be.isProtectedSignal()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)("gui.securitycraft:secure_redstone_interface.protected_signal.tooltip." + value)))).create(0, 0, widgetWidth, widgetHeight, (Component)Component.translatable((String)"gui.securitycraft:secure_redstone_interface.protected_signal"), (button, newValue) -> this.be.setProtectedSignal((boolean)newValue)));
            layout.addChild((LayoutElement)new CallbackSlider(0, 0, widgetWidth, widgetHeight, (Component)Component.translatable((String)"gui.securitycraft:projector.range", (Object[])new Object[]{""}), (Component)Component.empty(), 1.0, 64.0, this.be.getSenderRange(), true, slider -> this.be.setSenderRange(slider.getValueInt())));
        }
        layout.addChild((LayoutElement)CycleButton.builder(value -> Component.translatable((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).withValues((Object[])new Boolean[]{true, false}).withInitialValue((Object)this.be.shouldHighlightConnections()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"gui.securitycraft:secure_redstone_interface.highlight_connections.tooltip"))).create(0, 0, widgetWidth, widgetHeight, (Component)Component.translatable((String)"gui.securitycraft:secure_redstone_interface.highlight_connections"), (button, newValue) -> this.be.setHighlightConnections((boolean)newValue)));
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)this.leftPos, (int)this.topPos, (int)176, (int)(24 + (this.be.isSender() ? 188 : 142)));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, 176, 188, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int n = this.frequencyBox.getX();
        int n2 = this.frequencyBox.getY();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, this.frequencyText, n, n2 - 9 - 1, 0x404040, false);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, 0x404040, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        boolean sender = this.be.isSender();
        boolean protectedSignal = this.be.isProtectedSignal();
        int frequency = this.be.getFrequency();
        boolean sendsExactPower = this.be.sendsExactPower();
        boolean receivesInvertedPower = this.be.receivesInvertedPower();
        int senderRange = this.be.getSenderRange();
        boolean highlightConnections = this.be.shouldHighlightConnections();
        if (sender != this.oldSender || protectedSignal != this.oldProtectedSignal || frequency != this.oldFrequency || sendsExactPower != this.oldSendExactPower || receivesInvertedPower != this.oldReceiveInvertedPower || senderRange != this.oldSenderRange || highlightConnections != this.oldHighlightConnections) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncSecureRedstoneInterface(this.be.getBlockPos(), sender, protectedSignal, frequency, sendsExactPower, receivesInvertedPower, senderRange, highlightConnections), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

