/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class SSSConnectionList<T extends Screen>
extends ScrollPanel {
    private static final ResourceLocation CANCEL_SPRITE = SecurityCraft.mcResLoc("container/beacon/cancel");
    private static final int SLOT_HEIGHT = 12;
    private final T parent;
    private final List<ConnectionInfo> connectionInfo = new ArrayList<ConnectionInfo>();
    private final Font font;

    public SSSConnectionList(T parent, Minecraft client, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.parent = parent;
        this.font = client.font;
        this.refreshPositions();
    }

    public void refreshPositions() {
        ClientLevel level = Minecraft.getInstance().level;
        this.connectionInfo.clear();
        for (GlobalPos globalPos : ((ConnectionAccessor)this.parent).getPositions()) {
            MutableComponent blockName;
            if (globalPos == null) continue;
            BlockEntity be = level.getBlockEntity(globalPos.pos());
            if (be instanceof Nameable) {
                Nameable nameable = (Nameable)be;
                blockName = nameable.getDisplayName();
            } else {
                blockName = be != null ? Utils.localize(be.getBlockState().getBlock().getDescriptionId(), new Object[0]) : Component.literal((String)"????");
            }
            this.connectionInfo.add(new ConnectionInfo(globalPos, (Component)blockName));
        }
    }

    protected int getContentHeight() {
        int height = this.connectionInfo.size() * 12;
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    protected void drawBackground(GuiGraphics guiGraphics, Tesselator tess, float partialTick) {
        this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int slotBuffer = 8;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.connectionInfo.size() && mouseY >= this.top && mouseY <= this.bottom) {
            int min = this.left;
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            guiGraphics.fill(min, slotTop - 2, max, slotTop + slotBuffer + 2, -8355712);
            guiGraphics.fill(min + 1, slotTop - 1, max - 1, slotTop + slotBuffer + 1, -16777216);
            guiGraphics.blitSprite(RenderType::guiTextured, CANCEL_SPRITE, this.left + 2, slotTop - 2, 11, 11);
        }
        int i = 0;
        for (ConnectionInfo info : this.connectionInfo) {
            int yStart = relativeY + 12 * i++;
            guiGraphics.drawString(this.font, info.blockName, this.left + 13, yStart, 0xC6C6C6, false);
        }
        guiGraphics.flush();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.flush();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (slotIndex >= 0 && slotIndex < this.connectionInfo.size() && mouseListY >= 0 && mouseX >= this.left && mouseX < this.right - 6 && mouseY >= this.top && mouseY <= this.bottom) {
            Component blockName = this.connectionInfo.get((int)slotIndex).blockName;
            int length = this.font.width((FormattedText)blockName);
            int baseY = this.top + this.border - (int)this.scrollDistance;
            if (length + 13 >= this.width - 6) {
                guiGraphics.renderTooltip(this.font, List.of(blockName), Optional.empty(), this.left + 1, baseY + (12 * slotIndex + 12));
            }
            guiGraphics.drawString(this.font, Utils.getFormattedCoordinates(this.connectionInfo.get((int)slotIndex).globalPos.pos()), this.left + 13, this.top + this.height + 5, 0x404040, false);
        }
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        int slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12;
        if (slotIndex >= 0 && slotIndex < this.connectionInfo.size()) {
            Minecraft mc = Minecraft.getInstance();
            double relativeMouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
            if (relativeMouseY >= (double)this.top && relativeMouseY <= (double)this.bottom && mouseX < 13.0) {
                ((ConnectionAccessor)this.parent).removePosition(this.connectionInfo.get((int)slotIndex).globalPos);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
        }
        return false;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static interface ConnectionAccessor {
        public List<GlobalPos> getPositions();

        public void removePosition(GlobalPos var1);
    }

    private record ConnectionInfo(GlobalPos globalPos, Component blockName) {
    }
}

