/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Utils {
    public static final Style GRAY_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY);
    public static final Component INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    private Utils() {
    }

    public static Component getFormattedCoordinates(BlockPos pos) {
        return Component.translatable((String)"messages.securitycraft:formattedCoordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    public static MutableComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            Object object = params[i];
            if (object instanceof Component && (object = (component = (Component)object).getContents()) instanceof TranslatableContents) {
                TranslatableContents translatableContents = (TranslatableContents)object;
                params[i] = Utils.localize(translatableContents.getKey(), translatableContents.getArgs());
                continue;
            }
            object = params[i];
            if (!(object instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)object;
            params[i] = Utils.getFormattedCoordinates(pos);
        }
        return Component.translatable((String)key, (Object[])params);
    }

    public static ItemStack parseOptional(HolderLookup.Provider provider, CompoundTag tag) {
        return !tag.contains("id") || Items.AIR.toString().equals(tag.getString("id")) ? ItemStack.EMPTY : ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY);
    }

    public static BlockPos readBlockPos(CompoundTag tag) {
        return new BlockPos(tag.getInt("X"), tag.getInt("Y"), tag.getInt("Z"));
    }

    public static CompoundTag writeBlockPos(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("X", pos.getX());
        tag.putInt("Y", pos.getY());
        tag.putInt("Z", pos.getZ());
        return tag;
    }

    public static ResourceLocation getRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Potion potion) {
        return BuiltInRegistries.POTION.getKey((Object)potion);
    }

    public static String getLanguageKeyDenotation(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockEntity.class, Block.class, Entity.class, BlockState.class}, (Object)object2, n)) {
            case 0 -> {
                BlockEntity be = (BlockEntity)object2;
                yield Utils.getLanguageKeyDenotation(be.getBlockState().getBlock());
            }
            case 1 -> {
                Block block = (Block)object2;
                yield block.getDescriptionId().substring(6);
            }
            case 2 -> {
                Entity entity = (Entity)object2;
                yield entity.getType().toShortString();
            }
            case 3 -> {
                BlockState state = (BlockState)object2;
                yield Utils.getLanguageKeyDenotation(state.getBlock());
            }
            default -> "";
        };
    }
}

