/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedLecternBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock;
import net.geforcemods.securitycraft.components.Notes;
import net.geforcemods.securitycraft.entity.AbstractSecuritySeaBoat;
import net.geforcemods.securitycraft.entity.camera.CameraClientChunkCacheExtension;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.SendManualPages;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.MutablePair;

@EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    private static final Integer NOTE_DELAY = 9;
    public static final Map<Player, MutablePair<Integer, List<Notes.NoteWrapper>>> PLAYING_TUNES = new HashMap<Player, MutablePair<Integer, List<Notes.NoteWrapper>>>();

    private SCEventHandler() {
    }

    @SubscribeEvent
    public static void onServerTickPre(ServerTickEvent.Pre event) {
        SecurityCameraBlockEntity.resetForceLoadingCounter();
        if (!event.getServer().tickRateManager().isFrozen() || event.getServer().tickRateManager().isSteppingForward()) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    Notes.NoteWrapper note;
                    if (PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.PORTABLE_TUNE_PLAYER.get()).isEmpty()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    if (!((List)pair.getRight()).isEmpty() && (note = (Notes.NoteWrapper)((List)pair.getRight()).removeFirst()) != null) {
                        NoteBlockInstrument instrument = NoteBlockInstrument.valueOf((String)note.instrumentName().toUpperCase());
                        SoundEvent sound = instrument.hasCustomSound() && !note.customSound().isEmpty() ? SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)note.customSound())) : (SoundEvent)instrument.getSoundEvent().value();
                        float pitch = instrument.isTunable() ? (float)Math.pow(2.0, (double)(note.id() - 12) / 12.0) : 1.0f;
                        player.level().playSound(null, player.blockPosition(), sound, SoundSource.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.level(), player.blockPosition(), note.id(), instrument, note.customSound());
                        player.gameEvent((Holder)GameEvent.NOTE_BLOCK_PLAY);
                        pair.setLeft((Object)NOTE_DELAY);
                        return;
                    }
                    pair.setLeft((Object)-1);
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<Player, MutablePair<Integer, List<Notes.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SendManualPages(SCManualItem.PAGES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SendManualPages(SCManualItem.PAGES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Level level = event.getLevel();
            Entity entity2 = player.getCamera();
            if (entity2 instanceof SecurityCamera) {
                BlockEntity blockEntity;
                SecurityCamera cam = (SecurityCamera)entity2;
                if (player.getEffect(MobEffects.NIGHT_VISION) instanceof CameraNightVisionEffectInstance) {
                    player.removeEffect(MobEffects.NIGHT_VISION);
                }
                if ((blockEntity = level.getBlockEntity(cam.blockPosition())) instanceof SecurityCameraBlockEntity) {
                    SecurityCameraBlockEntity camBe = (SecurityCameraBlockEntity)blockEntity;
                    camBe.stopViewing();
                }
                cam.discard();
            }
            for (SecurityCameraBlockEntity viewedCamera : BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(level, be -> be.getCameraFeedChunks(player) != null || be.hasPlayerFrameLink((Player)player))) {
                viewedCamera.unlinkFrameForPlayer(player.getUUID(), null);
                viewedCamera.clearCameraFeedChunks(player);
            }
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        PasscodeUtils.startHashingThread((Executor)event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLevelLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            SaltData.refreshLevel(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        ServerLevel serverLevel;
        LevelAccessor level = event.getLevel();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).dimension() == Level.OVERWORLD) {
            SaltData.invalidate();
            BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.clear();
        } else if (level.isClientSide()) {
            FrameFeedHandler.removeAllFeeds();
            CameraClientChunkCacheExtension.clear();
            CameraViewAreaExtension.clear();
        }
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        PasscodeUtils.stopHashingThread();
    }

    @SubscribeEvent
    public static void onEntityInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        if (event.getEntity() instanceof AbstractSecuritySeaBoat && event.getSource().is(SCTags.DamageTypes.SECURITY_SEA_BOAT_VULNERABLE_TO)) {
            event.setInvulnerable(false);
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            int reinforcedSuffocationDamage;
            ServerPlayer player = (ServerPlayer)livingEntity;
            ServerLevel level = player.level();
            DamageSource damageSource = event.getSource();
            if (!player.isCreative() && damageSource.equals(level.damageSources().inWall()) && !player.isInvulnerableTo(level, damageSource) && BlockUtils.isInsideUnownedReinforcedBlocks((Level)level, (Player)player, player.getEyePosition(), player.getBbWidth()) && (reinforcedSuffocationDamage = ((Integer)ConfigHandler.SERVER.reinforcedSuffocationDamage.get()).intValue()) != -1) {
                player.hurt(CustomDamageSources.inReinforcedWall(level.registryAccess()), (float)reinforcedSuffocationDamage);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingDamageEvent.Post event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (event.getSource().is(CustomDamageSources.ELECTRICITY)) {
            level.playSound(null, entity.blockPosition(), SCSounds.ELECTRIFIED.event, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (PlayerUtils.isPlayerMountedOnCamera(entity)) {
                ((SecurityCamera)player.getCamera()).stopViewing(player);
            }
        }
    }

    @SubscribeEvent
    public static void onDismount(EntityMountEvent event) {
        Entity entity;
        if (((Boolean)ConfigHandler.SERVER.preventReinforcedFloorGlitching.get()).booleanValue() && event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof Boat) {
            Boat boat = (Boat)entity;
            entity = event.getEntityMounting();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.getAbilities().invulnerable) {
                    Vec3 incorrectDismountLocation = new Vec3(boat.getX(), boat.getBoundingBox().maxY, boat.getZ());
                    Vec3 dismountLocation = boat.getDismountLocationForPassenger((LivingEntity)player);
                    Vec3 newCenterPos = dismountLocation.add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
                    Vec3 newEyePos = dismountLocation.add(0.0, (double)player.getEyeHeight(), 0.0);
                    if (dismountLocation.equals((Object)incorrectDismountLocation) && (BlockUtils.isInsideUnownedReinforcedBlocks(player.level(), player, newEyePos, player.getBbWidth()) || BlockUtils.isInsideUnownedReinforcedBlocks(player.level(), player, newCenterPos, player.getBbWidth()))) {
                        player.setYRot(boat.getYRot() + 180.0f);
                        dismountLocation = boat.getDismountLocationForPassenger((LivingEntity)player);
                        if (!dismountLocation.equals((Object)incorrectDismountLocation)) {
                            player.setPos(dismountLocation);
                        } else {
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemOnBlock(UseItemOnBlockEvent event) {
        BlockPos pos;
        Level level;
        BlockState state;
        ItemStack stack;
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.ITEM_AFTER_BLOCK && ((stack = event.getItemStack()).is(Items.WRITABLE_BOOK) || stack.is(Items.WRITTEN_BOOK)) && (state = (level = event.getLevel()).getBlockState(pos = event.getPos())).is((Block)SCContent.REINFORCED_LECTERN.get())) {
            Player player;
            ReinforcedLecternBlockEntity be = (ReinforcedLecternBlockEntity)level.getBlockEntity(pos);
            if (be.isOwnedBy((Entity)(player = event.getPlayer())) && LecternBlock.tryPlaceBook((LivingEntity)player, (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.isEmpty() || stack.getItem() instanceof BlockItem || stack.is(SCTags.Items.CAN_INTERACT_WITH_DOORS))) {
            Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
            if (block == SCContent.KEYPAD_DOOR.get()) {
                event.setUseItem(TriState.FALSE);
            } else if (block == SCContent.REINFORCED_DOOR.get() || block == SCContent.REINFORCED_IRON_TRAPDOOR.get() || block == SCContent.SCANNER_DOOR.get()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IOwnable ownable;
        Owner owner;
        ILockable lockable;
        Player player = event.getEntity();
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            event.setCanceled(true);
            return;
        }
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockEntity be = level.getBlockEntity(pos);
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (be instanceof ILockable && (lockable = (ILockable)be).isLocked() && lockable.disableInteractionWhenLocked(level, pos, player) && !player.isShiftKeyDown()) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                MutableComponent blockName = Utils.localize(block.getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (be instanceof IOwnable && !(owner = (ownable = (IOwnable)be).getOwner()).isValidated()) {
            if (ownable.isOwnedBy((Entity)player)) {
                owner.setValidated(true);
                ownable.onValidate();
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(block.getDescriptionId(), new Object[0]), Component.translatable((String)"messages.securitycraft:ownable.validate"), ChatFormatting.GREEN);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(block.getDescriptionId(), new Object[0]), Component.translatable((String)"messages.securitycraft:ownable.ownerNotValidated"), ChatFormatting.RED);
            }
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            return;
        }
        if (!level.isClientSide) {
            BlockEntity blockEntity;
            IOwnable ownable2;
            IEMPAffected empAffected;
            if (event.getItemStack().is(Items.REDSTONE) && be instanceof IEMPAffected && (empAffected = (IEMPAffected)be).isShutDown()) {
                empAffected.reactivate();
                if (!player.isCreative()) {
                    event.getItemStack().shrink(1);
                }
                player.swing(event.getHand());
                event.setCanceled(true);
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                return;
            }
            ItemStack heldItem = player.getItemInHand(event.getHand());
            if (heldItem.is((Item)SCContent.KEY_PANEL.get()) && (!(be instanceof IOwnable) || (ownable2 = (IOwnable)be).isOwnedBy((Entity)player))) {
                for (IPasscodeConvertible pc : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                    if (!pc.isUnprotectedBlock(state)) continue;
                    event.setUseBlock(TriState.FALSE);
                    event.setUseItem(TriState.TRUE);
                }
                return;
            }
            if (heldItem.is((Item)SCContent.CODEBREAKER.get()) && (blockEntity = level.getBlockEntity(pos)) instanceof ICodebreakable) {
                ICodebreakable codebreakable = (ICodebreakable)blockEntity;
                codebreakable.handleCodebreaking(player, event.getHand());
                event.setCanceled(true);
                return;
            }
        }
        if (block instanceof DisplayCaseBlock && player.isShiftKeyDown() && player.getMainHandItem().isEmpty() && !player.getOffhandItem().isEmpty()) {
            event.setUseBlock(TriState.TRUE);
            event.setUseItem(TriState.FALSE);
            return;
        }
        List sentries = level.getEntitiesOfClass(Sentry.class, new AABB(pos));
        if (!sentries.isEmpty()) {
            event.setCanceled(((Sentry)sentries.get(0)).mobInteract(player, event.getHand()) == InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (((Boolean)ConfigHandler.SERVER.inWorldUnReinforcing.get()).booleanValue()) {
            if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
                event.setCanceled(true);
                return;
            }
            ItemStack stack = event.getEntity().getMainHandItem();
            Item held = stack.getItem();
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            if (held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) {
                UniversalBlockReinforcerItem.maybeRemoveMending((HolderLookup.Provider)level.registryAccess(), stack);
                if (UniversalBlockReinforcerItem.convertBlock(level.getBlockState(pos), level, stack, pos, event.getEntity())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (event.getPlayer().isCreative() && !(sentries = level.getEntitiesOfClass(Sentry.class, new AABB(event.getPos()))).isEmpty()) {
            event.setCanceled(true);
            return;
        }
        if (!level.isClientSide()) {
            IModuleInventory be;
            BlockPos pos = event.getPos();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IModuleInventory && (be = (IModuleInventory)blockEntity).shouldDropModules()) {
                for (int i = 0; i < be.getMaxNumberOfModules(); ++i) {
                    if (((ItemStack)be.getInventory().get(i)).isEmpty()) continue;
                    ItemStack stack = (ItemStack)be.getInventory().get(i);
                    ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                    LevelUtils.addScheduledTask((LevelAccessor)level, () -> level.addFreshEntity((Entity)item));
                    be.onModuleRemoved(stack, ((ModuleItem)stack.getItem()).getModuleType(), false);
                    if (be instanceof LinkableBlockEntity) {
                        LinkableBlockEntity lbe = (LinkableBlockEntity)be;
                        lbe.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.getItem()).getModuleType(), false), lbe);
                    }
                    if (!(be instanceof SecurityCameraBlockEntity)) continue;
                    SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)be;
                    BlockPos camPos = cam.getBlockPos();
                    BlockState camState = level.getBlockState(camPos);
                    level.updateNeighborsAt(camPos.relative((Direction)camState.getValue(SecurityCameraBlock.FACING), -1), camState.getBlock());
                }
            }
            Player player = event.getPlayer();
            BlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getBlockEntitiesInRange(level, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.DetectionMode.BREAK, pos, state));
        }
    }

    @SubscribeEvent
    public static void onBlockEventPlace(BlockEvent.EntityPlaceEvent event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getBlockEntitiesInRange(level, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.DetectionMode.PLACE, pos, state));
        }
    }

    @SubscribeEvent
    public static void onPlayerHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (((Boolean)ConfigHandler.SERVER.alwaysDrop.get()).booleanValue() && event.getLevel().getBlockEntity(event.getPos()) instanceof IOwnable) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
        if (blockEntity instanceof IOwnable) {
            IOwnable ownable = (IOwnable)blockEntity;
            String name = event.getPlayer().getName().getString();
            String uuid = event.getPlayer().getGameProfile().getId().toString();
            ownable.setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingChangeTargetEvent event) {
        if (event.getNewAboutToBeSetTarget() instanceof Sentry) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherBoss && event.getState().getBlock() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity()) && event.getItemStack().getItem() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        BlockItem blockItem;
        Item item = event.getItemStack().getItem();
        if (item instanceof BlockItem && ((blockItem = (BlockItem)item).getBlock() instanceof ReinforcedCarpetBlock || blockItem.getBlock() == SCContent.ELECTRIFIED_IRON_FENCE_GATE.get())) {
            event.setBurnTime(0);
        }
    }

    @SubscribeEvent
    public static void onAnvilCraftPre(AnvilUpdateEvent event) {
        ItemStack book;
        ItemStack stack = event.getLeft();
        if (stack.getItem() instanceof UniversalBlockReinforcerItem && ((ItemEnchantments)(book = event.getRight()).getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().anyMatch(e -> e.is(Enchantments.MENDING))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        List<RiftStabilizerBlockEntity> targetPosBlockEntities = BlockEntityTracker.RIFT_STABILIZER.getBlockEntitiesInRange(level, event.getTarget());
        List<RiftStabilizerBlockEntity> sourcePosBlockEntities = BlockEntityTracker.RIFT_STABILIZER.getBlockEntitiesInRange(level, event.getPrev());
        List<Object> blockEntities = new ArrayList<RiftStabilizerBlockEntity>();
        RiftStabilizerBlockEntity.TeleportationType type = RiftStabilizerBlockEntity.TeleportationType.getTypeFromEvent(event);
        RiftStabilizerBlockEntity riftStabilizer = null;
        boolean targetPosProhibited = false;
        blockEntities.addAll(targetPosBlockEntities);
        blockEntities.addAll(sourcePosBlockEntities);
        blockEntities = blockEntities.stream().distinct().sorted(Comparator.comparingDouble(b -> Math.min(b.getBlockPos().distToCenterSqr((Position)event.getTarget()), b.getBlockPos().distToCenterSqr((Position)event.getPrev())))).toList();
        for (RiftStabilizerBlockEntity riftStabilizerBlockEntity : blockEntities) {
            Player player;
            if (riftStabilizerBlockEntity.isDisabled() || !riftStabilizerBlockEntity.getFilter(type) || entity instanceof Player && (riftStabilizerBlockEntity.isOwnedBy((Entity)(player = (Player)entity)) && riftStabilizerBlockEntity.ignoresOwner() || riftStabilizerBlockEntity.isAllowed((Entity)player))) continue;
            riftStabilizer = riftStabilizerBlockEntity;
            targetPosProhibited = riftStabilizerBlockEntity.getBlockPos().distToCenterSqr((Position)event.getTarget()) < riftStabilizerBlockEntity.getBlockPos().distToCenterSqr((Position)event.getPrev());
            break;
        }
        if (riftStabilizer != null) {
            BlockPos pos = riftStabilizer.getBlockPos();
            Vec3 vec3 = new AABB(pos).getCenter();
            Vec3 from = targetPosProhibited ? event.getTarget() : event.getPrev();
            Vec3 distance = from.subtract(vec3);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                level.playSound(null, event.getPrevX(), event.getPrevY(), event.getPrevZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.5f);
                PlayerUtils.sendMessageToPlayer(player, ((RiftStabilizerBlock)SCContent.RIFT_STABILIZER.get()).getName(), Component.translatable((String)(targetPosProhibited ? "messages.securitycraft:rift_stabilizer.no_teleport_to" : "messages.securitycraft:rift_stabilizer.no_teleport_from")), ChatFormatting.RED);
                if (riftStabilizer.isModuleEnabled(ModuleType.HARMING)) {
                    player.hurt(entity.damageSources().fall(), 5.0f);
                }
            }
            riftStabilizer.setLastTeleport(Math.max(Math.abs(distance.x), Math.max(Math.abs(distance.y), Math.abs(distance.z))) - 0.5, type);
            if (riftStabilizer.isModuleEnabled(ModuleType.REDSTONE)) {
                int signalLength = riftStabilizer.getSignalLength();
                level.setBlockAndUpdate(pos, (BlockState)riftStabilizer.getBlockState().cycle((Property)RiftStabilizerBlock.POWERED));
                BlockUtils.updateIndirectNeighbors(level, pos, (Block)SCContent.RIFT_STABILIZER.get());
                if (signalLength > 0) {
                    level.scheduleTick(pos, (Block)SCContent.RIFT_STABILIZER.get(), signalLength);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote((Level)event.getLevel(), event.getPos(), event.getVanillaNoteId(), event.getInstrument(), "");
    }

    private static void handlePlayedNote(Level level, BlockPos pos, int vanillaNoteId, NoteBlockInstrument instrument, String customSoundId) {
        SkullBlockEntity be;
        ResourceLocation noteBlockSound;
        BlockEntity blockEntity;
        List<SonicSecuritySystemBlockEntity> sonicSecuritySystems = BlockEntityTracker.SONIC_SECURITY_SYSTEM.getBlockEntitiesInRange(level, pos);
        if (customSoundId.isEmpty() && instrument.hasCustomSound() && (blockEntity = level.getBlockEntity(pos.above())) instanceof SkullBlockEntity && (noteBlockSound = (be = (SkullBlockEntity)blockEntity).getNoteBlockSound()) != null) {
            customSoundId = noteBlockSound.toString();
        }
        for (SonicSecuritySystemBlockEntity be2 : sonicSecuritySystems) {
            if (!be2.isActive()) continue;
            if (be2.isRecording()) {
                be2.recordNote(vanillaNoteId, instrument, customSoundId);
                continue;
            }
            be2.listenToNote(vanillaNoteId, instrument, customSoundId);
        }
    }
}

