/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCCreativeModeTabs;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBarrelBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.KeypadTrapDoorBlock;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRedstoneBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.hudmods.TOPDataProvider;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.ConfigAttackTargetCheck;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.util.HasManualPage;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="securitycraft")
@EventBusSubscriber(modid="securitycraft")
public class SecurityCraft {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "securitycraft";
    public static final Supplier<GameRules.Key<GameRules.BooleanValue>> RULE_FAKE_WATER_SOURCE_CONVERSION = Suppliers.memoize(() -> GameRules.register((String)"fakeWaterSourceConversion", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.create((boolean)true)));
    public static final Supplier<GameRules.Key<GameRules.BooleanValue>> RULE_FAKE_LAVA_SOURCE_CONVERSION = Suppliers.memoize(() -> GameRules.register((String)"fakeLavaSourceConversion", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.create((boolean)false)));
    public static final Random RANDOM = new Random();
    public static final TicketController CAMERA_TICKET_CONTROLLER = new TicketController(SecurityCraft.resLoc("camera_chunks"), (level, ticketHelper) -> {
        ticketHelper.getEntityTickets().forEach((uuid, chunk) -> {
            if (level.getEntity(uuid) == null) {
                ticketHelper.removeAllTickets(uuid);
            }
        });
        ticketHelper.getBlockTickets().forEach((pos, chunk) -> {
            if (!(level.getBlockEntity(pos) instanceof SecurityCameraBlockEntity) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getTrackedBlockEntities((Level)level).contains(pos)) {
                ticketHelper.removeAllTickets(pos);
            }
        });
    });

    public SecurityCraft(IEventBus modEventBus, ModContainer container) {
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(SecurityCraft::addReloadListener);
        NeoForge.EVENT_BUS.addListener(SecurityCraft::onServerStarted);
        NeoForge.EVENT_BUS.addListener(RegistrationHandler::registerBrewingRecipes);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHandler.SERVER_SPEC);
        SCContent.BLOCKS.register(modEventBus);
        SCContent.BLOCK_ENTITY_TYPES.register(modEventBus);
        SCContent.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        SCContent.DATA_COMPONENTS.register(modEventBus);
        SCContent.DATA_SERIALIZERS.register(modEventBus);
        SCContent.ENTITY_TYPES.register(modEventBus);
        SCContent.FLUIDS.register(modEventBus);
        SCContent.ITEMS.register(modEventBus);
        SCContent.LOOT_ITEM_CONDITION_TYPES.register(modEventBus);
        SCContent.MENU_TYPES.register(modEventBus);
        SCContent.PARTICLE_TYPES.register(modEventBus);
        SCContent.RECIPE_SERIALIZERS.register(modEventBus);
        SCCreativeModeTabs.CREATIVE_MODE_TABS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RULE_FAKE_WATER_SOURCE_CONVERSION.get();
            RULE_FAKE_LAVA_SOURCE_CONVERSION.get();
        });
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", ReinforcedHopperBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", IMSBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadBarrelBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadChestBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadTrapDoorBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.FURNACE, (Block)SCContent.KEYPAD_FURNACE.get()));
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.SMOKER, (Block)SCContent.KEYPAD_SMOKER.get()));
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.BLAST_FURNACE, (Block)SCContent.KEYPAD_BLAST_FURNACE.get()));
        InterModComms.sendTo((String)MODID, (String)"registerSentryAttackTargetCheck", ConfigAttackTargetCheck::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", CommonDoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", InventoryScannerBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedPressurePlateBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedRedstoneBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", SecureRedstoneInterfaceBlock.DoorActivator::new);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        ReinforcedCauldronBlock.IReinforcedCauldronInteraction.bootStrap();
    }

    public static void onServerStarted(ServerStartedEvent event) {
        SecurityCraft.collectSCContentData(event.getServer(), true);
    }

    public static void addReloadListener(AddServerReloadListenersEvent event) {
        event.addListener(SecurityCraft.resLoc("collect_sc_content_data"), (barrier, manager, e1, e2) -> CompletableFuture.runAsync(() -> SecurityCraft.collectSCContentData(true), e1).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0)));
    }

    @SubscribeEvent
    public static void onRegisterTicketControllers(RegisterTicketControllersEvent event) {
        event.register(CAMERA_TICKET_CONTROLLER);
    }

    public static void collectSCContentData(boolean addPages) {
        SecurityCraft.collectSCContentData(ServerLifecycleHooks.getCurrentServer(), addPages);
    }

    public static void collectSCContentData(MinecraftServer server, boolean addPages) {
        if (addPages && server == null) {
            return;
        }
        EnumMap<PageGroup, List> groupStacks = new EnumMap<PageGroup, List>(PageGroup.class);
        IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.clear();
        IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.clear();
        if (addPages) {
            SCManualItem.PAGES.clear();
        }
        for (Field field : SCContent.class.getFields()) {
            try {
                if (field.isAnnotationPresent(Reinforced.class)) {
                    Block block = (Block)((DeferredBlock)field.get(null)).get();
                    IReinforcedBlock rb = (IReinforcedBlock)block;
                    IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.put(rb.getVanillaBlock(), block);
                    IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.put(block, rb.getVanillaBlock());
                }
                if (!field.isAnnotationPresent(HasManualPage.class)) continue;
                Object o = ((DeferredHolder)field.get(null)).get();
                HasManualPage hmp = field.getAnnotation(HasManualPage.class);
                Item item = ((ItemLike)o).asItem();
                PageGroup group2 = hmp.value();
                boolean wasNotAdded = false;
                MutableComponent title = Component.translatable((String)"");
                Object key = "help.";
                if (group2 != PageGroup.NONE) {
                    if (!groupStacks.containsKey((Object)group2)) {
                        groupStacks.put(group2, new ArrayList());
                        title = Utils.localize(group2.getTitle(), new Object[0]);
                        key = (String)key + group2.getSpecialInfoKey();
                        wasNotAdded = true;
                    }
                    ((List)groupStacks.get((Object)group2)).add(new ItemStack((ItemLike)item));
                } else {
                    title = Utils.localize(item.getDescriptionId(), new Object[0]);
                    key = (String)key + item.getDescriptionId().substring(5) + ".info";
                }
                if (!addPages || group2 != PageGroup.NONE && !wasNotAdded) continue;
                SCManualItem.PAGES.add(new SCManualPage(item, group2, (Component)title, (Component)Component.translatable((String)((String)key).replace("..", ".")), hmp.designedBy(), hmp.hasRecipeDescription(), (Supplier<Optional<List<RecipeDisplay>>>)Suppliers.memoize(() -> SCManualItem.findRecipes(server, item, group2))));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        groupStacks.forEach((group, list) -> group.setItems(list.stream().filter(stack -> !stack.isEmpty()).toList()));
    }

    public void registerCommands(RegisterCommandsEvent event) {
        SCCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static String getVersion() {
        return "v" + ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().toString();
    }

    public static ResourceLocation resLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static ResourceLocation mcResLoc(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }
}

