/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class LinkableBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    protected List<LinkedBlock> linkedBlocks = new ArrayList<LinkedBlock>();
    private ValueInput.TypedInputList<LinkedBlock> nbtTagStorage = null;

    protected LinkableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.hasLevel() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        if (!this.hasLevel()) {
            this.nbtTagStorage = tag.listOrEmpty("linkedBlocks", LinkedBlock.NEW_OR_LEGACY_CODEC);
            return;
        }
        this.readLinkedBlocks((ValueInput.TypedInputList<LinkedBlock>)tag.listOrEmpty("linkedBlocks", LinkedBlock.NEW_OR_LEGACY_CODEC));
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (!this.linkedBlocks.isEmpty()) {
            ValueOutput.TypedOutputList tagList = tag.list("linkedBlocks", LinkedBlock.CODEC);
            this.linkedBlocks.forEach(arg_0 -> ((ValueOutput.TypedOutputList)tagList).add(arg_0));
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        LinkableBlockEntity.unlinkFromAllLinked(this);
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        this.propagate(new ILinkedAction.OptionChanged<T>(option), this);
        super.onOptionChanged(option);
    }

    private void readLinkedBlocks(ValueInput.TypedInputList<LinkedBlock> list) {
        for (LinkedBlock block : list) {
            if (!this.hasLevel() || !this.level.isLoaded(block.pos()) || !block.validate(this.level) || this.linkedBlocks.contains(block)) continue;
            LinkableBlockEntity.link(this, block.asBlockEntity(this.level));
        }
    }

    public static void link(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (LinkableBlockEntity.isLinkedWith(blockEntity1, blockEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(blockEntity1);
        LinkedBlock block2 = new LinkedBlock(blockEntity2);
        if (!blockEntity1.linkedBlocks.contains(block2)) {
            blockEntity1.linkedBlocks.add(block2);
            blockEntity1.setChanged();
        }
        if (!blockEntity2.linkedBlocks.contains(block1)) {
            blockEntity2.linkedBlocks.add(block1);
            blockEntity2.setChanged();
        }
    }

    public static void unlink(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (blockEntity1 == null || blockEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(blockEntity2);
        if (blockEntity1.linkedBlocks.contains(block)) {
            blockEntity1.linkedBlocks.remove(block);
            blockEntity1.setChanged();
        }
    }

    public static void unlinkFromAllLinked(LinkableBlockEntity blockEntity) {
        if (blockEntity == null) {
            return;
        }
        Level level = blockEntity.level;
        for (LinkedBlock block : blockEntity.linkedBlocks) {
            if (!level.isLoaded(block.pos())) continue;
            LinkableBlockEntity.unlink(block.asBlockEntity(level), blockEntity);
        }
        blockEntity.setChanged();
    }

    public static boolean isLinkedWith(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        return blockEntity1.linkedBlocks.contains(new LinkedBlock(blockEntity2)) && blockEntity2.linkedBlocks.contains(new LinkedBlock(blockEntity1));
    }

    public void propagate(ILinkedAction action, LinkableBlockEntity excludedBE) {
        ArrayList<LinkableBlockEntity> list = new ArrayList<LinkableBlockEntity>();
        list.add(excludedBE);
        this.propagate(action, list);
    }

    public void propagate(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        Iterator<LinkedBlock> linkedBlockIterator = this.linkedBlocks.iterator();
        while (linkedBlockIterator.hasNext()) {
            LinkedBlock block = linkedBlockIterator.next();
            if (!this.level.isLoaded(block.pos()) || excludedBEs.contains(block.asBlockEntity(this.level))) continue;
            if (block.validate(this.level)) {
                BlockState state = this.level.getBlockState(block.pos());
                block.asBlockEntity(this.level).onLinkedBlockAction(action, excludedBEs);
                this.level.sendBlockUpdated(block.pos(), state, state, 3);
                continue;
            }
            linkedBlockIterator.remove();
        }
    }

    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
    }
}

