/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public record LinkedBlock(String blockName, BlockPos pos) {
    public static final Codec<LinkedBlock> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("block_name").forGetter(LinkedBlock::blockName), (App)BlockPos.CODEC.fieldOf("pos").forGetter(LinkedBlock::pos)).apply((Applicative)i, LinkedBlock::new));
    public static final Codec<LinkedBlock> LEGACY_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("blockName").forGetter(LinkedBlock::blockName), (App)Codec.INT.fieldOf("blockX").forGetter(lb -> lb.pos().getX()), (App)Codec.INT.fieldOf("blockY").forGetter(lb -> lb.pos().getY()), (App)Codec.INT.fieldOf("blockZ").forGetter(lb -> lb.pos().getZ())).apply((Applicative)i, (name, x, y, z) -> new LinkedBlock((String)name, new BlockPos(x.intValue(), y.intValue(), z.intValue()))));
    public static final Codec<LinkedBlock> NEW_OR_LEGACY_CODEC = Codec.withAlternative(CODEC, LEGACY_CODEC);

    public LinkedBlock(LinkableBlockEntity blockEntity) {
        this(blockEntity.getBlockState().getBlock().getDescriptionId(), blockEntity.getBlockPos());
    }

    public boolean validate(Level level) {
        return level != null && level.getBlockState(this.pos).getBlock().getDescriptionId().equals(this.blockName);
    }

    public LinkableBlockEntity asBlockEntity(Level level) {
        if (!this.validate(level)) {
            return null;
        }
        return (LinkableBlockEntity)level.getBlockEntity(this.pos);
    }

    @Override
    public String toString() {
        return this.blockName + " | " + this.pos.getX() + " " + this.pos.getY() + " " + this.pos.getZ();
    }
}

