/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketWallBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedCrystalQuartzPillar;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedPillarBlock;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPocketManagerBlockEntity
extends CustomizableBlockEntity
implements MenuProvider,
ITickingBlockEntity,
ILockable {
    private static final int BLOCK_PLACEMENTS_PER_TICK = 4;
    private boolean enabled = false;
    private boolean showOutline = false;
    private int color = -16776961;
    private int size = 5;
    private int autoBuildOffset = 0;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();
    protected NonNullList<ItemStack> storage = NonNullList.withSize((int)56, (Object)ItemStack.EMPTY);
    private List<Pair<BlockPos, BlockState>> placeQueue = new ArrayList<Pair<BlockPos, BlockState>>();
    private boolean shouldPlaceBlocks = false;

    public BlockPocketManagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.shouldPlaceBlocks) {
            Object owner = PlayerUtils.getPlayerFromName(this.getOwner().getName());
            if (owner == null) {
                this.placeQueue.clear();
                this.shouldPlaceBlocks = false;
                return;
            }
            boolean isCreative = owner.isCreative();
            boolean placed4Blocks = true;
            block0: for (int i = 0; i < 4; ++i) {
                Pair<BlockPos, BlockState> toPlace;
                BlockState stateInLevel;
                do {
                    if (this.placeQueue.isEmpty()) {
                        placed4Blocks = false;
                        break block0;
                    }
                    toPlace = this.placeQueue.remove(0);
                    if (((BlockState)toPlace.getRight()).getBlock() instanceof IBlockPocket) continue;
                    throw new IllegalStateException(String.format("Tried to automatically place non-block pocket block \"%s\"! This mustn't happen!", ((BlockState)toPlace.getRight()).getBlock().getDescriptionId()));
                } while ((stateInLevel = level.getBlockState((BlockPos)toPlace.getLeft())) == toPlace.getRight());
                if (stateInLevel.canBeReplaced()) {
                    BlockPos placeLocation = (BlockPos)toPlace.getLeft();
                    BlockState stateToPlace = (BlockState)toPlace.getRight();
                    SoundType soundType = stateToPlace.getSoundType();
                    if (!isCreative) {
                        for (int k = 0; k < this.storage.size(); ++k) {
                            ItemStack stackToCheck = (ItemStack)this.storage.get(k);
                            if (stackToCheck.isEmpty() || ((BlockItem)stackToCheck.getItem()).getBlock() != stateToPlace.getBlock()) continue;
                            stackToCheck.shrink(1);
                            break;
                        }
                    }
                    level.setBlockAndUpdate(placeLocation, stateToPlace);
                    level.playSound(null, placeLocation, soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
                    level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, placeLocation);
                    BlockEntity placedBe = level.getBlockEntity(placeLocation);
                    if (!(placedBe instanceof OwnableBlockEntity)) continue;
                    OwnableBlockEntity ownable = (OwnableBlockEntity)placedBe;
                    ownable.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
                    continue;
                }
                PlayerUtils.sendMessageToPlayer(owner, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).getDescriptionId(), new Object[0]), Component.translatable((String)"messages.securitycraft:blockpocket.assemblyFailed", (Object[])new Object[]{this.getFormattedRelativeCoordinates((BlockPos)toPlace.getLeft(), (Direction)state.getValue(BlockPocketManagerBlock.FACING)), Component.translatable((String)stateInLevel.getBlock().getDescriptionId())}), ChatFormatting.DARK_AQUA);
                placed4Blocks = false;
                break;
            }
            if (!placed4Blocks) {
                if (!this.placeQueue.isEmpty()) {
                    this.placeQueue.clear();
                } else {
                    this.setWalls(!this.isModuleEnabled(ModuleType.DISGUISE));
                    PlayerUtils.sendMessageToPlayer(owner, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).getDescriptionId(), new Object[0]), Component.translatable((String)"messages.securitycraft:blockpocket.assembled"), ChatFormatting.DARK_AQUA);
                }
                this.shouldPlaceBlocks = false;
            }
        }
    }

    public MutableComponent enableMultiblock() {
        if (this.level.isClientSide) {
            return Component.translatable((String)"enableMultiblock called on client! Send a ToggleBlockPocketManager packet instead.");
        }
        if (!this.isEnabled()) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
            Direction managerFacing = (Direction)this.level.getBlockState(this.worldPosition).getValue(BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.getClockWise();
            Direction right = left.getOpposite();
            Direction back = left.getClockWise();
            boolean lowest = false;
            int highest = this.getSize() - 1;
            BlockPos pos = this.getBlockPos().immutable();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int offset = 0;
            if (!(this.level.getBlockState(pos.relative(left)).getBlock() instanceof IBlockPocket)) {
                offset = -this.getAutoBuildOffset() + this.getSize() / 2;
                pos = pos.relative(left, offset);
            } else {
                for (int i = 1; i < this.getSize() - 1; ++i) {
                    if (this.level.getBlockState(pos.relative(left, i)).getBlock() instanceof ReinforcedRotatedCrystalQuartzPillar) continue;
                    offset = i;
                    pos = pos.relative(left, offset);
                    break;
                }
                if (offset == 0) {
                    offset = -this.getAutoBuildOffset() + this.getSize() / 2;
                    pos = pos.relative(left, offset);
                }
            }
            BlockPos startingPos = pos.immutable();
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.relative(right, xi);
                        BlockState currentState = this.level.getBlockState(currentPos);
                        if (currentState.getBlock() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.getBlockPos())) {
                            return Component.translatable((String)"messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.getBlockPos()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.getBlock() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((BlockPocketBlock)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).getDescriptionId())});
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.getValue((Property)BlockStateProperties.AXIS) != typeToCheckFor) {
                                    if (currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                    }
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).getDescriptionId())});
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.getValue((Property)BlockStateProperties.AXIS) != typeToCheckFor) {
                                    if (currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                    }
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).getDescriptionId())});
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.getBlock() instanceof BlockPocketWallBlock)) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).getDescriptionId())});
                                }
                                floor.add(currentPos);
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.getValue((Property)BlockStateProperties.AXIS) != Direction.Axis.Y) {
                                if (currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                }
                                return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).getDescriptionId())});
                            }
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            if (!(currentState.getBlock() instanceof BlockPocketWallBlock)) {
                                return Component.translatable((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId()), Component.translatable((String)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).getDescriptionId())});
                            }
                            sides.add(currentPos);
                        }
                        if (!this.getOwner().owns((OwnableBlockEntity)this.level.getBlockEntity(currentPos))) {
                            return Component.translatable((String)"messages.securitycraft:blockpocket.unowned", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.above(yi).relative(back, ++zi);
                }
                zi = 0;
                pos = startingPos.above(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.floor = floor;
            this.setEnabled(true);
            this.setAutoBuildOffset(-offset + this.getSize() / 2);
            this.setChanged();
            for (BlockPos blockPos : blocks) {
                BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.setManager(this);
            }
            for (BlockPos blockPos : floor) {
                this.level.setBlockAndUpdate(blockPos, (BlockState)this.level.getBlockState(blockPos).setValue((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(true)));
            }
            this.setWalls(!this.isModuleEnabled(ModuleType.DISGUISE));
            return Component.translatable((String)"messages.securitycraft:blockpocket.activated");
        }
        return null;
    }

    public MutableComponent autoAssembleMultiblock() {
        if (this.level.isClientSide) {
            return Component.translatable((String)"autoAssembleMultiblock called on client! Send an AssembleBlockPocket packet instead.");
        }
        if (!this.isEnabled()) {
            BlockState currentState;
            BlockPos currentPos;
            Direction managerFacing = (Direction)this.getBlockState().getValue(BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.getClockWise();
            Direction right = left.getOpposite();
            Direction back = left.getClockWise();
            boolean lowest = false;
            int half = (this.getSize() - 1) / 2 - this.getAutoBuildOffset();
            int highest = this.getSize() - 1;
            BlockPos pos = this.getBlockPos().immutable();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.relative(right, -half);
            BlockPos startingPos = pos.immutable();
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        BlockEntity blockEntity;
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.relative(right, xi);
                        currentState = this.level.getBlockState(currentPos);
                        boolean replaceable = currentState.canBeReplaced();
                        if (yi == 0 && !currentPos.equals((Object)this.getBlockPos()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.getBlock() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() && !replaceable) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                }
                                if (replaceable) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.getValue((Property)BlockStateProperties.AXIS) != typeToCheckFor) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.getValue((Property)BlockStateProperties.AXIS) != typeToCheckFor) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.getBlock() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.getBlock() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.getBlock() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.getValue((Property)BlockStateProperties.AXIS) != Direction.Axis.Y) {
                                return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                            }
                            if (replaceable) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            if (!(currentState.getBlock() instanceof BlockPocketWallBlock) && !replaceable) {
                                return Component.translatable((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                            }
                            if (replaceable) {
                                ++wallsNeeded;
                            }
                        }
                        if ((blockEntity = this.level.getBlockEntity(currentPos)) instanceof OwnableBlockEntity) {
                            OwnableBlockEntity be = (OwnableBlockEntity)blockEntity;
                            if (!this.getOwner().owns(be)) {
                                return Component.translatable((String)"messages.securitycraft:blockpocket.unowned", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.translatable((String)currentState.getBlock().asItem().getDescriptionId())});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.above(yi).relative(back, ++zi);
                }
                zi = 0;
                pos = startingPos.above(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return Component.translatable((String)"messages.securitycraft:blockpocket.alreadyAssembled");
            }
            pos = this.getBlockPos().immutable().relative(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.relative(right, xi);
                        currentState = this.level.getBlockState(currentPos);
                        if (currentState.getBlock() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.getBlockPos())) {
                            return Component.translatable((String)"messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.getBlockPos()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketBlock)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).defaultBlockState()));
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).defaultBlockState().setValue(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).defaultBlockState().setValue(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).defaultBlockState()));
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).defaultBlockState().setValue(ReinforcedRotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y))));
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).defaultBlockState()));
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.above(yi).relative(back, ++zi);
                }
                zi = 0;
                pos = startingPos.above(++yi);
            }
            this.shouldPlaceBlocks = true;
            return null;
        }
        return null;
    }

    public MutableComponent disableMultiblock() {
        if (this.level.isClientSide) {
            return Component.literal((String)"disableMultiblock called on client! Send a ToggleBlockPocketManager packet instead.");
        }
        if (this.isEnabled()) {
            this.setEnabled(false);
            for (BlockPos pos : this.blocks) {
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.removeManager();
            }
            for (BlockPos pos : this.floor) {
                BlockState state = this.level.getBlockState(pos);
                if (!state.hasProperty((Property)BlockPocketWallBlock.SOLID)) continue;
                this.level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.isModuleEnabled(ModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            return Utils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]);
        }
        return null;
    }

    private Component getFormattedRelativeCoordinates(BlockPos pos, Direction managerFacing) {
        int offsetBehind;
        BlockPos difference = pos.subtract((Vec3i)this.worldPosition);
        int offsetAbove = difference.getY();
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        int offsetLeft = switch (managerFacing) {
            case Direction.NORTH -> {
                offsetBehind = difference.getZ();
                yield difference.getX();
            }
            case Direction.SOUTH -> {
                offsetBehind = -difference.getZ();
                yield -difference.getX();
            }
            case Direction.WEST -> {
                offsetBehind = difference.getX();
                yield -difference.getZ();
            }
            case Direction.EAST -> {
                offsetBehind = -difference.getX();
                yield difference.getZ();
            }
            default -> throw new IllegalArgumentException("Invalid Block Pocket Manager direction: " + managerFacing.name());
        };
        if (offsetLeft > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksLeft", offsetLeft));
        } else if (offsetLeft < 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksRight", -offsetLeft));
        }
        if (offsetBehind > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksBehind", offsetBehind));
        }
        if (offsetAbove > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksAbove", offsetAbove));
        }
        return Utils.localize("messages.securitycraft:blockpocket.position." + components.size(), components.toArray());
    }

    public void toggleOutline() {
        this.setShowOutline(!this.showsOutline());
        this.setChanged();
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            BlockState state = this.level.getBlockState(pos);
            if (!(state.getBlock() instanceof BlockPocketWallBlock)) continue;
            this.level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockPocketWallBlock.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    public static IItemHandler getCapability(BlockPocketManagerBlockEntity be, Direction side) {
        if (!be.isPlacingBlocks() && BlockUtils.isAllowedToExtractFromProtectedObject(side, be)) {
            return new ValidityCheckItemStackHandler(be.storage);
        }
        return new ValidityCheckInsertOnlyItemStackHandler(be.storage);
    }

    public NonNullList<ItemStack> getStorage() {
        return this.storage;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (this.isEnabled() && module == ModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (this.isEnabled() && module == ModuleType.DISGUISE) {
            this.setWalls(true);
        } else if (module == ModuleType.STORAGE) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, this.storage);
        }
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        int i;
        tag.putBoolean("BlockPocketEnabled", this.isEnabled());
        tag.putBoolean("ShowOutline", this.showsOutline());
        tag.putInt("Size", this.getSize());
        tag.putInt("AutoBuildOffset", this.getAutoBuildOffset());
        tag.putInt("Color", this.color);
        ContainerHelper.saveAllItems((ValueOutput)tag, this.storage);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.putLong("BlocksList" + i, this.blocks.get(i).asLong());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.putLong("WallsList" + i, this.walls.get(i).asLong());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.putLong("FloorList" + i, this.floor.get(i).asLong());
        }
        super.saveAdditional(tag);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        int i = 0;
        super.loadAdditional(tag);
        this.setEnabled(tag.getBooleanOr("BlockPocketEnabled", false));
        this.setShowOutline(tag.getBooleanOr("ShowOutline", false));
        this.setSize(tag.getIntOr("Size", 5));
        this.setAutoBuildOffset(tag.getIntOr("AutoBuildOffset", 0));
        this.setColor(tag.getIntOr("Color", -16776961));
        ContainerHelper.loadAllItems((ValueInput)tag, this.storage);
        while (tag.getLong("BlocksList" + i).isPresent()) {
            this.blocks.add(BlockPos.of((long)tag.getLongOr("BlocksList" + i, 0L)));
            ++i;
        }
        i = 0;
        while (tag.getLong("WallsList" + i).isPresent()) {
            this.walls.add(BlockPos.of((long)tag.getLongOr("WallsList" + i, 0L)));
            ++i;
        }
        i = 0;
        while (tag.getLong("FloorList" + i).isPresent()) {
            this.floor.add(BlockPos.of((long)tag.getLongOr("FloorList" + i, 0L)));
            ++i;
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, this.getStorage());
            this.disableMultiblock();
        }
        super.preRemoveSideEffects(pos, state);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.STORAGE};
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.getBaseModuleDescriptionId(denotation, module);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new BlockPocketManagerMenu(windowId, this.level, this.worldPosition, inv);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public boolean isPlacingBlocks() {
        return this.shouldPlaceBlocks;
    }

    public static boolean isItemValid(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            return block == SCContent.BLOCK_POCKET_WALL.get() || block == SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() || block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get();
        }
        return false;
    }

    public void setColor(int color) {
        this.color = Mth.clamp((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setAutoBuildOffset(int autoBuildOffset) {
        this.autoBuildOffset = autoBuildOffset;
    }

    public int getAutoBuildOffset() {
        return this.autoBuildOffset;
    }

    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
    }

    public boolean showsOutline() {
        return this.showOutline;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class ValidityCheckItemStackHandler
    extends ItemStackHandler {
        public ValidityCheckItemStackHandler(NonNullList<ItemStack> stacks) {
            super(stacks);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BlockPocketManagerBlockEntity.isItemValid(stack);
        }
    }

    public static class ValidityCheckInsertOnlyItemStackHandler
    extends InsertOnlyItemStackHandler {
        public ValidityCheckInsertOnlyItemStackHandler(NonNullList<ItemStack> stacks) {
            super(stacks);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BlockPocketManagerBlockEntity.isItemValid(stack);
        }
    }
}

