/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class KeycardLockBlockEntity
extends KeycardReaderBlockEntity {
    protected Option.BooleanOption exactLevel = new Option.BooleanOption("exactLevel", true);
    private boolean setUp = false;

    public KeycardLockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYCARD_LOCK_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public InteractionResult onRightClickWithActionItem(ItemStack stack, InteractionHand hand, Player player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (!this.isSetUp() && this.isOwnedBy((Entity)player)) {
            Item item = stack.getItem();
            if (item instanceof KeycardItem) {
                String keySuffix;
                KeycardItem item2 = (KeycardItem)item;
                boolean[] levels = new boolean[]{false, false, false, false, false};
                if (((Boolean)this.exactLevel.get()).booleanValue()) {
                    levels[item2.getLevel()] = true;
                    keySuffix = "exact";
                } else {
                    for (int i = item2.getLevel(); i < 5; ++i) {
                        levels[i] = true;
                    }
                    keySuffix = "above";
                }
                this.setUp = true;
                this.setAcceptedLevels(levels);
                this.setSignature(((KeycardData)stack.getOrDefault(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT)).signature());
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.setup_successful." + keySuffix, item2.getLevel() + 1), ChatFormatting.GREEN);
                return InteractionResult.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.not_set_up", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        return super.onRightClickWithActionItem(stack, hand, player, isCodebreaker, isKeycardHolder);
    }

    public boolean isSetUp() {
        return this.setUp;
    }

    @Override
    public void reset() {
        super.reset();
        this.setUp = false;
        this.acceptedLevels = new boolean[]{false, false, false, false, false};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.exactLevel) {
            boolean[] acceptedLevels = this.getAcceptedLevels();
            boolean swap = false;
            for (int i = 0; i < acceptedLevels.length; ++i) {
                if (swap) {
                    acceptedLevels[i] = !acceptedLevels[i];
                    continue;
                }
                if (!acceptedLevels[i]) continue;
                swap = true;
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putBoolean("set_up", this.setUp);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.setUp = tag.getBooleanOr("set_up", false);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendDenylistMessage, this.signalLength, this.disabled, this.exactLevel};
    }
}

