/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventoryWithContainer;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements IModuleInventoryWithContainer,
MenuProvider,
ILockable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    private boolean activatedByRedstone = false;
    private boolean active = false;
    private boolean horizontal = false;
    private boolean overridingBlocks = false;
    private ItemStack projectedBlock = ItemStack.EMPTY;
    private BlockState projectedState = Blocks.AIR.defaultBlockState();

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putInt("width", this.projectionWidth);
        tag.putInt("height", this.projectionHeight);
        tag.putInt("range", this.projectionRange);
        tag.putInt("offset", this.projectionOffset);
        tag.putBoolean("active", this.active);
        tag.putBoolean("horizontal", this.horizontal);
        tag.putBoolean("overriding_blocks", this.overridingBlocks);
        if (!this.projectedBlock.isEmpty()) {
            tag.store("storedItem", ItemStack.CODEC, (Object)this.projectedBlock);
        }
        tag.store("SavedState", BlockState.CODEC, (Object)this.projectedState);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.projectionWidth = tag.getIntOr("width", 1);
        this.projectionHeight = tag.getIntOr("height", 1);
        this.projectionRange = tag.getIntOr("range", 5);
        this.projectionOffset = tag.getIntOr("offset", 0);
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
        this.active = tag.getBooleanOr("active", false);
        this.horizontal = tag.getBooleanOr("horizontal", false);
        this.overridingBlocks = tag.getBooleanOr("overriding_blocks", false);
        this.projectedBlock = tag.read("storedItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        tag.read("SavedState", BlockState.CODEC).ifPresentOrElse(this::setProjectedState, this::resetSavedState);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)this.getStackInSlot(36));
        }
        super.preRemoveSideEffects(pos, state);
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
        this.setChanged();
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
        this.setChanged();
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
        this.setChanged();
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
        this.setChanged();
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
        this.setChanged();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.setChanged();
    }

    public boolean isOverridingBlocks() {
        return this.overridingBlocks;
    }

    public void setOverridingBlocks(boolean overridingBlocks) {
        this.overridingBlocks = overridingBlocks;
    }

    public boolean isActive() {
        return !this.activatedByRedstone || this.active;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
        this.setChanged();
    }

    public BlockState getProjectedState() {
        return this.projectedState;
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new ProjectorMenu(windowId, this.level, this.worldPosition, inv);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Override
    public ItemStack removeContainerItem(int index, int count, boolean simulate) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            if (!simulate) {
                this.projectedBlock = ItemStack.EMPTY;
                this.resetSavedState();
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    public int getContainerStackSize() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return !this.isContainer(slot) ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.EMPTY);
    }

    @Override
    public ItemStack getStackInContainer(int slot) {
        return this.getStackInSlot(slot);
    }

    @Override
    public void setContainerItem(int index, ItemStack stack) {
        if (!stack.isEmpty() && stack.getCount() > this.getContainerStackSize()) {
            stack = new ItemStack((ItemLike)stack.getItem(), this.getContainerStackSize());
        }
        ItemStack old = this.projectedBlock;
        this.projectedBlock = stack;
        if (old.getItem() != this.projectedBlock.getItem()) {
            this.resetSavedState();
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, this.projectedState, this.projectedBlock);
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    public void setProjectedState(BlockState projectedState) {
        if (this.level != null && this.level.isClientSide) {
            if (this.projectedState.getBlock() != projectedState.getBlock()) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, projectedState, this.projectedBlock);
        }
        this.projectedState = projectedState;
        this.setChanged();
    }

    public void resetSavedState() {
        Item item = this.projectedBlock.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setProjectedState(blockItem.getBlock().defaultBlockState());
        } else {
            this.projectedState = Blocks.AIR.defaultBlockState();
            if (this.level != null && this.level.isClientSide) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            this.setChanged();
        }
    }

    public StandingOrWallType getStandingOrWallType() {
        Item item;
        if (this.projectedState != null && this.projectedBlock != null && (item = this.projectedBlock.getItem()) instanceof StandingAndWallBlockItem) {
            StandingAndWallBlockItem sawbi = (StandingAndWallBlockItem)item;
            if (this.projectedState.getBlock() == sawbi.getBlock()) {
                return StandingOrWallType.STANDING;
            }
            if (this.projectedState.getBlock() == sawbi.wallBlock) {
                return StandingOrWallType.WALL;
            }
        }
        return StandingOrWallType.NONE;
    }

    @Override
    public boolean isItemValidForContainer(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isContainerEmpty() {
        return this.projectedBlock.isEmpty();
    }
}

