/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private static final Map<ServerPlayer, Set<SecurityCameraBlockEntity>> RECENTLY_UNVIEWED_CAMERAS = new HashMap<ServerPlayer, Set<SecurityCameraBlockEntity>>();
    private static final Map<ResourceKey<Level>, Set<Long>> FORCE_LOADED_CAMERA_CHUNKS = new HashMap<ResourceKey<Level>, Set<Long>>();
    private static int forceLoadingCounter = 0;
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private final Set<Long> chunkForceLoadQueue = new HashSet<Long>();
    private Map<UUID, ChunkTrackingView.Positioned> cameraFeedChunks = new HashMap<UUID, ChunkTrackingView.Positioned>();
    private Map<UUID, Set<Long>> linkedFrames = new HashMap<UUID, Set<Long>>();
    private Set<UUID> playersRequestingChunks = new HashSet<UUID>();
    private int maxChunkLoadingRadius = 0;
    private boolean down = false;
    private boolean initialized = false;
    private int playersViewing = 0;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption("rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption("movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption("customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption("opacity", 100, 0, 255, 1);
    private LensContainer lens = new LensContainer(1);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.initialized) {
            Direction facing = (Direction)state.getValue(SecurityCameraBlock.FACING);
            this.initialized = true;
            boolean bl = this.down = facing == Direction.DOWN;
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection(facing, this.initialZoom);
            }
        }
        if (!level.isClientSide && !this.chunkForceLoadQueue.isEmpty()) {
            HashSet<Long> queueCopy = new HashSet<Long>(this.chunkForceLoadQueue);
            for (Long chunkPosLong : queueCopy) {
                if (forceLoadingCounter > 16) break;
                Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)level.dimension(), d -> new HashSet());
                ChunkPos chunkPos = new ChunkPos(chunkPosLong.longValue());
                if (!forceLoadedChunksInDimension.contains(chunkPosLong)) {
                    SecurityCraft.CAMERA_TICKET_CONTROLLER.forceChunk((ServerLevel)level, this.worldPosition, chunkPos.x, chunkPos.z, true, false);
                    forceLoadedChunksInDimension.add(chunkPosLong);
                    ++forceLoadingCounter;
                }
                this.chunkForceLoadQueue.remove(chunkPosLong);
            }
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                GlobalPos cameraPos;
                this.cameraRotation = (Double)this.customRotationOption.get();
                if (level.isClientSide && this.cameraRotation != this.oCameraRotation && FrameFeedHandler.hasFeed(cameraPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos))) {
                    FrameFeedHandler.getFeed(cameraPos).requestFrustumUpdate();
                }
                return;
            }
            if (this.down) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
                if (this.oCameraRotation >= 6.2831854820251465) {
                    this.cameraRotation %= 6.2831854820251465;
                    this.oCameraRotation %= 6.2831854820251465;
                }
            } else {
                if (this.addToRotation && this.getCameraRotation() <= 1.5707963705062866) {
                    this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
                } else {
                    this.addToRotation = false;
                }
                if (!this.addToRotation && this.getCameraRotation() >= -1.5707963705062866) {
                    this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
                } else {
                    this.addToRotation = true;
                }
            }
            if (!level.isClientSide) {
                level.sendBlockUpdated(pos, state, state, 2);
            }
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        this.unlinkAllFrames();
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.unlinkAllFrames();
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putDouble("camera_rotation", this.cameraRotation);
        tag.putBoolean("add_to_rotation", this.addToRotation);
        tag.putBoolean("shutDown", this.shutDown);
        this.lens.storeAsItemList(tag.list("lens", ItemStack.CODEC));
        tag.putFloat("initial_x_rotation", this.initialXRotation);
        tag.putFloat("initial_y_rotation", this.initialYRotation);
        tag.putFloat("initial_zoom", this.initialZoom);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.cameraRotation = tag.getDoubleOr("camera_rotation", 0.0);
        this.addToRotation = tag.getBooleanOr("add_to_rotation", false);
        this.shutDown = tag.getBooleanOr("shutDown", false);
        this.lens.fromItemList(tag.listOrEmpty("lens", ItemStack.CODEC));
        this.initialXRotation = tag.getFloatOr("initial_x_rotation", 1.0f);
        this.initialYRotation = tag.getFloatOr("initial_y_rotation", 1.0f);
        this.initialZoom = tag.getFloatOr("initial_zoom", this.initialZoom);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
                this.dropAllModules();
            }
            Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getLensContainer());
        }
        super.preRemoveSideEffects(pos, state);
    }

    public static IItemHandler getCapability(SecurityCameraBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new InvWrapper((Container)be.lens) : new InsertOnlyInvWrapper((Container)be.lens);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.level, this.worldPosition, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((Direction)this.getBlockState().getValue(SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option.getName().equals("disabled") && !this.level.isClientSide && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            for (ServerPlayer player : ((ServerLevel)this.level).players()) {
                SecurityCamera camera;
                Entity entity = player.getCamera();
                if (!(entity instanceof SecurityCamera) || !(camera = (SecurityCamera)entity).blockPosition().equals((Object)this.worldPosition)) continue;
                camera.stopViewing(player);
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public void shutDown() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        IEMPAffectedBE.super.shutDown();
        if (state.getBlock() == SCContent.SECURITY_CAMERA.get() && ((Boolean)state.getValue((Property)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public void linkFrameForPlayer(ServerPlayer player, BlockPos framePos, int chunkLoadingDistance) {
        Set playerViewedFrames = this.linkedFrames.computeIfAbsent(player.getUUID(), uuid -> new HashSet());
        BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.track(this);
        this.requestChunkSending(player, chunkLoadingDistance);
        if (chunkLoadingDistance > this.maxChunkLoadingRadius) {
            Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)this.level.dimension(), d -> new HashSet());
            int frameFeedForceloadingLimit = (Integer)ConfigHandler.SERVER.frameFeedForceloadingLimit.get();
            if (frameFeedForceloadingLimit >= 0 && frameFeedForceloadingLimit <= forceLoadedChunksInDimension.size()) {
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:frame.forceloadingLimitReached", new Object[0]), ChatFormatting.RED);
            } else {
                ChunkPos cameraChunkPos = new ChunkPos(this.worldPosition);
                Long cameraChunkPosLong = cameraChunkPos.toLong();
                if (!forceLoadedChunksInDimension.contains(cameraChunkPosLong)) {
                    SecurityCraft.CAMERA_TICKET_CONTROLLER.forceChunk((ServerLevel)this.level, this.worldPosition, cameraChunkPos.x, cameraChunkPos.z, true, false);
                    this.chunkForceLoadQueue.add(cameraChunkPosLong);
                }
                for (int x = cameraChunkPos.x - chunkLoadingDistance; x <= cameraChunkPos.x + chunkLoadingDistance; ++x) {
                    for (int z = cameraChunkPos.z - chunkLoadingDistance; z <= cameraChunkPos.z + chunkLoadingDistance; ++z) {
                        Long forceLoadingPos = ChunkPos.asLong((int)x, (int)z);
                        if (forceLoadedChunksInDimension.contains(forceLoadingPos)) continue;
                        this.chunkForceLoadQueue.add(forceLoadingPos);
                    }
                }
                this.maxChunkLoadingRadius = chunkLoadingDistance;
            }
        }
        playerViewedFrames.add(framePos.asLong());
    }

    public void unlinkFrameForPlayer(UUID playerUUID, BlockPos framePos) {
        if (this.linkedFrames.containsKey(playerUUID)) {
            Set<Long> linkedFramesPerPlayer = this.linkedFrames.get(playerUUID);
            if (framePos != null) {
                linkedFramesPerPlayer.remove(framePos.asLong());
            }
            if (framePos == null || linkedFramesPerPlayer.isEmpty()) {
                this.linkedFrames.remove(playerUUID);
            }
            if (this.linkedFrames.isEmpty()) {
                Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)this.level.dimension(), d -> new HashSet());
                SectionPos cameraChunkPos = SectionPos.of((BlockPos)this.worldPosition);
                SecurityCameraBlockEntity.addRecentlyUnviewedCamera(this);
                BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.stopTracking(this);
                for (int x = cameraChunkPos.getX() - this.maxChunkLoadingRadius; x <= cameraChunkPos.getX() + this.maxChunkLoadingRadius; ++x) {
                    for (int z = cameraChunkPos.getZ() - this.maxChunkLoadingRadius; z <= cameraChunkPos.getZ() + this.maxChunkLoadingRadius; ++z) {
                        ChunkPos chunkPos = new ChunkPos(x, z);
                        Long chunkPosLong = chunkPos.toLong();
                        if (!forceLoadedChunksInDimension.contains(chunkPosLong) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(this.level, be -> be.shouldKeepChunkForceloaded(chunkPos)).isEmpty()) continue;
                        SecurityCraft.CAMERA_TICKET_CONTROLLER.forceChunk((ServerLevel)this.level, this.worldPosition, x, z, false, false);
                        forceLoadedChunksInDimension.remove(chunkPosLong);
                    }
                }
                this.maxChunkLoadingRadius = 0;
            }
        }
    }

    public void unlinkFrameForAllPlayers(BlockPos framePos) {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, framePos);
        }
    }

    public void unlinkAllFrames() {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, null);
        }
        if (this.level.isClientSide) {
            FrameFeedHandler.removeAllFrameLinks(GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition));
        }
    }

    public boolean hasPlayerFrameLink(Player player) {
        return this.linkedFrames.containsKey(player.getUUID());
    }

    public boolean isFrameLinked(Player player, BlockPos framePos) {
        return this.hasPlayerFrameLink(player) && this.linkedFrames.get(player.getUUID()).contains(framePos.asLong());
    }

    public void requestChunkSending(ServerPlayer player, int chunkLoadingDistance) {
        this.setChunkLoadingDistance(player, chunkLoadingDistance);
        this.playersRequestingChunks.add(player.getUUID());
    }

    public ChunkTrackingView.Positioned getCameraFeedChunks(ServerPlayer player) {
        return this.cameraFeedChunks.get(player.getUUID());
    }

    public void clearCameraFeedChunks(ServerPlayer player) {
        this.cameraFeedChunks.remove(player.getUUID());
    }

    public void setChunkLoadingDistance(ServerPlayer player, int chunkLoadingDistance) {
        this.cameraFeedChunks.put(player.getUUID(), (ChunkTrackingView.Positioned)ChunkTrackingView.of((ChunkPos)new ChunkPos(this.worldPosition), (int)chunkLoadingDistance));
    }

    public boolean shouldKeepChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        UUID uuid = player.getUUID();
        return this.cameraFeedChunks.containsKey(uuid) && this.cameraFeedChunks.get(uuid).contains(chunkX, chunkZ);
    }

    public boolean shouldSendChunksToPlayer(ServerPlayer player) {
        return this.playersRequestingChunks.remove(player.getUUID());
    }

    public boolean shouldKeepChunkForceloaded(ChunkPos chunkPos) {
        ChunkPos cameraPos = new ChunkPos(this.worldPosition);
        return chunkPos.x >= cameraPos.x - this.maxChunkLoadingRadius && chunkPos.x <= cameraPos.x + this.maxChunkLoadingRadius && chunkPos.z >= cameraPos.z - this.maxChunkLoadingRadius && chunkPos.z <= cameraPos.z + this.maxChunkLoadingRadius;
    }

    public static void addRecentlyUnviewedCamera(SecurityCameraBlockEntity camera) {
        for (ServerPlayer player : camera.level.getServer().getPlayerList().getPlayers()) {
            Set unviewingCameras = RECENTLY_UNVIEWED_CAMERAS.computeIfAbsent(player, p -> new HashSet());
            unviewingCameras.add(camera);
        }
    }

    public static boolean hasRecentlyUnviewedCameras(ServerPlayer player) {
        return RECENTLY_UNVIEWED_CAMERAS.containsKey(player);
    }

    public static Set<SecurityCameraBlockEntity> fetchRecentlyUnviewedCameras(ServerPlayer player) {
        return RECENTLY_UNVIEWED_CAMERAS.remove(player);
    }

    public static void resetForceLoadingCounter() {
        forceLoadingCounter = 0;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public boolean shouldRotate() {
        return (Boolean)this.shouldRotateOption.get();
    }

    public float getDefaultXRotation() {
        return this.down ? 75.0f : 30.0f;
    }

    public float getDefaultYRotation(Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.DOWN, Direction.UP -> 0.0f;
        };
    }

    public void setDefaultViewingDirection(Direction facing, float zoom) {
        this.setDefaultViewingDirection(this.getDefaultXRotation(), this.getDefaultYRotation(facing), zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.setChanged();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }
}

