/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class AbstractKeypadFurnaceBlock
extends DisguisableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final VoxelShape NORTH_OPEN = Stream.of(Block.box((double)11.0, (double)1.0, (double)1.0, (double)12.0, (double)2.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)1.0), Block.box((double)4.0, (double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape NORTH_CLOSED = Stream.of(Block.box((double)4.0, (double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0), Block.box((double)11.0, (double)14.0, (double)1.0, (double)12.0, (double)15.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape EAST_OPEN = Stream.of(Block.box((double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), Block.box((double)14.0, (double)1.0, (double)4.0, (double)15.0, (double)2.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape EAST_CLOSED = Stream.of(Block.box((double)14.0, (double)14.0, (double)4.0, (double)15.0, (double)15.0, (double)5.0), Block.box((double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SOUTH_OPEN = Stream.of(Block.box((double)4.0, (double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0, (double)16.0), Block.box((double)11.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SOUTH_CLOSED = Stream.of(Block.box((double)11.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)15.0), Block.box((double)4.0, (double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)4.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape WEST_OPEN = Stream.of(Block.box((double)1.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)5.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)2.0, (double)12.0), Block.box((double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape WEST_CLOSED = Stream.of(Block.box((double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0, (double)12.0), Block.box((double)1.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)5.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape NORTH_COLLISION = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_COLLISION = Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected AbstractKeypadFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return switch ((Direction)disguisedState.getValue(FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)disguisedState.getValue((Property)OPEN)).booleanValue()) {
                    yield NORTH_OPEN;
                }
                yield NORTH_CLOSED;
            }
            case Direction.EAST -> {
                if (((Boolean)disguisedState.getValue((Property)OPEN)).booleanValue()) {
                    yield EAST_OPEN;
                }
                yield EAST_CLOSED;
            }
            case Direction.SOUTH -> {
                if (((Boolean)disguisedState.getValue((Property)OPEN)).booleanValue()) {
                    yield SOUTH_OPEN;
                }
                yield SOUTH_CLOSED;
            }
            case Direction.WEST -> {
                if (((Boolean)disguisedState.getValue((Property)OPEN)).booleanValue()) {
                    yield WEST_OPEN;
                }
                yield WEST_CLOSED;
            }
            default -> Shapes.block();
        };
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return switch ((Direction)disguisedState.getValue(FACING)) {
            case Direction.NORTH -> NORTH_COLLISION;
            case Direction.EAST -> EAST_COLLISION;
            case Direction.SOUTH -> SOUTH_COLLISION;
            case Direction.WEST -> WEST_COLLISION;
            default -> Shapes.block();
        };
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            AbstractKeypadFurnaceBlockEntity be = (AbstractKeypadFurnaceBlockEntity)level.getBlockEntity(pos);
            if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(be, level, pos, player);
                } else {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(AbstractKeypadFurnaceBlockEntity be, Level level, BlockPos pos, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, pos);
            serverPlayer.openMenu((MenuProvider)be);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractKeypadFurnaceBlockEntity) {
            AbstractKeypadFurnaceBlockEntity be = (AbstractKeypadFurnaceBlockEntity)blockEntity;
            be.recheckOpen();
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, LIT, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public static class Convertible
    implements IPasscodeConvertible {
        private final Block unprotectedBlock;
        private final Block protectedBlock;

        public Convertible(Block unprotectedBlock, Block protectedBlock) {
            this.unprotectedBlock = unprotectedBlock;
            this.protectedBlock = protectedBlock;
        }

        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.is(this.unprotectedBlock);
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.is(this.protectedBlock);
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            return this.convert(player, level, pos, this.protectedBlock, true);
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            return this.convert(player, level, pos, this.unprotectedBlock, false);
        }

        public boolean convert(Player player, Level level, BlockPos pos, Block convertedBlock, boolean protect) {
            BlockState state = level.getBlockState(pos);
            Direction facing = (Direction)state.getValue(FACING);
            boolean lit = (Boolean)state.getValue((Property)LIT);
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)level.getBlockEntity(pos);
            BlockState convertedState = (BlockState)((BlockState)convertedBlock.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)LIT, (Comparable)Boolean.valueOf(lit));
            if (protect) {
                convertedState = (BlockState)convertedState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
            } else {
                ((IModuleInventory)furnace).dropAllModules();
            }
            CompoundTag tag = furnace.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            furnace.clearContent();
            level.setBlockAndUpdate(pos, convertedState);
            furnace = (AbstractFurnaceBlockEntity)level.getBlockEntity(pos);
            try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(furnace.problemPath(), SecurityCraft.LOGGER);){
                furnace.loadWithComponents(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)tag));
            }
            if (protect && player != null) {
                ((IOwnable)furnace).setOwner(player.getUUID().toString(), player.getName().getString());
            }
            return true;
        }
    }
}

