/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadBarrelBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;

public class KeypadBarrelBlock
extends DisguisableBlock {
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<LidFacing> LID_FACING = EnumProperty.create((String)"lid_facing", LidFacing.class);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty FROG = BooleanProperty.create((String)"frog");

    public KeypadBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(LID_FACING, (Comparable)((Object)LidFacing.UP))).setValue((Property)FROG, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(LID_FACING, (Comparable)((Object)LidFacing.fromDirection(ctx.getNearestLookingDirection().getOpposite())));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        KeypadBarrelBlockEntity be = (KeypadBarrelBlockEntity)level.getBlockEntity(pos);
        if (stack.is(Items.FROG_SPAWN_EGG) && be.isOwnedBy((Entity)player)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)FROG));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        KeypadBarrelBlockEntity be;
        if (!level.isClientSide && (be = (KeypadBarrelBlockEntity)level.getBlockEntity(pos)).verifyPasscodeSet(level, pos, be, player)) {
            if (be.isDenied((Entity)player)) {
                if (be.sendsDenylistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (be.isAllowed((Entity)player)) {
                if (be.sendsAllowlistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(state, level, pos, player);
            } else {
                be.openPasscodeGUI(level, pos, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider menuProvider;
        if (!level.isClientSide && (menuProvider = this.getMenuProvider(state, level, pos)) != null) {
            player.openMenu(menuProvider);
            player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_BARREL));
        }
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof KeypadBarrelBlockEntity) {
            KeypadBarrelBlockEntity barrel = (KeypadBarrelBlockEntity)blockEntity;
            barrel.recheckOpen();
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeypadBarrelBlockEntity(pos, state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue(HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, LID_FACING, OPEN, FROG, WATERLOGGED});
    }

    public static enum LidFacing implements StringRepresentable
    {
        UP("up"),
        SIDEWAYS("sideways"),
        DOWN("down");

        private final String name;

        private LidFacing(String name) {
            this.name = name;
        }

        public static LidFacing fromDirection(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP -> UP;
                case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> SIDEWAYS;
                case Direction.DOWN -> DOWN;
            };
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.is(Tags.Blocks.BARRELS_WOODEN);
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.is((Block)SCContent.KEYPAD_BARREL.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            BarrelBlockEntity barrel = (BarrelBlockEntity)level.getBlockEntity(pos);
            LidFacing generalFacing = LidFacing.fromDirection((Direction)state.getValue((Property)BarrelBlock.FACING));
            barrel.unpackLootTable(player);
            CompoundTag tag = barrel.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            barrel.clearContent();
            Direction horizontalFacing = switch (generalFacing.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> {
                    if (player == null) {
                        yield Direction.NORTH;
                    }
                    yield player.getDirection().getOpposite();
                }
                case 1 -> (Direction)state.getValue((Property)BarrelBlock.FACING);
            };
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((KeypadBarrelBlock)SCContent.KEYPAD_BARREL.get()).defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)horizontalFacing)).setValue(LID_FACING, (Comparable)((Object)generalFacing))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
            KeypadBarrelBlockEntity keypadBarrel = (KeypadBarrelBlockEntity)level.getBlockEntity(pos);
            try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(keypadBarrel.problemPath(), SecurityCraft.LOGGER);){
                keypadBarrel.loadWithComponents(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)tag));
            }
            keypadBarrel.setPreviousBarrel(state.getBlock());
            if (player != null) {
                keypadBarrel.setOwner(player.getUUID().toString(), player.getName().getString());
            }
            return true;
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            KeypadBarrelBlockEntity keypadBarrel = (KeypadBarrelBlockEntity)level.getBlockEntity(pos);
            LidFacing lidFacing = (LidFacing)((Object)state.getValue(LID_FACING));
            Direction direction = switch (lidFacing.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Direction.UP;
                case 1 -> (Direction)state.getValue(HORIZONTAL_FACING);
                case 2 -> Direction.DOWN;
            };
            Block convertedBlock = BuiltInRegistries.BLOCK.get(keypadBarrel.getPreviousBarrel()).map(Holder.Reference::value).orElse(Blocks.BARREL);
            keypadBarrel.dropAllModules();
            keypadBarrel.unpackLootTable(player);
            CompoundTag tag = keypadBarrel.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            keypadBarrel.clearContent();
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)convertedBlock.defaultBlockState().setValue((Property)BarrelBlock.FACING, (Comparable)direction)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
            BarrelBlockEntity barrel = (BarrelBlockEntity)level.getBlockEntity(pos);
            try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(barrel.problemPath(), SecurityCraft.LOGGER);){
                barrel.loadWithComponents(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)tag));
            }
            return true;
        }
    }
}

