/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FallingBlockMineBlock
extends BaseFullMineBlock
implements Fallable {
    public FallingBlockMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties, disguisedBlock);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean flag) {
        level.scheduleTick(pos, (Block)this, 2);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        tickAccess.scheduleTick(pos, (Block)this, 2);
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinY()) {
            BlockEntity be = level.getBlockEntity(pos);
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos));
            entity.blockData = be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            level.addFreshEntity((Entity)entity);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(16) == 0 && FallingBlock.isFree((BlockState)level.getBlockState(pos.below()))) {
            double particleX = (float)pos.getX() + rand.nextFloat();
            double particleY = (double)pos.getY() - 0.05;
            double particleZ = (float)pos.getZ() + rand.nextFloat();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }
}

