/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.ReinforcedDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedDoorBlock
extends OwnableBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public ReinforcedDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(FACING);
        boolean isNotOpen = (Boolean)state.getValue((Property)OPEN) == false;
        boolean isHingeRight = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch (facing) {
            case Direction.EAST -> {
                if (isNotOpen) {
                    yield EAST_AABB;
                }
                if (isHingeRight) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (isNotOpen) {
                    yield SOUTH_AABB;
                }
                if (isHingeRight) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (isNotOpen) {
                    yield WEST_AABB;
                }
                if (isHingeRight) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> {
                if (isNotOpen) {
                    yield NORTH_AABB;
                }
                if (isHingeRight) {
                    yield WEST_AABB;
                }
                yield EAST_AABB;
            }
            default -> isNotOpen ? EAST_AABB : (isHingeRight ? NORTH_AABB : SOUTH_AABB);
        };
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        DoubleBlockHalf doorHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() == Direction.Axis.Y && doorHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.getBlock() == this && facingState.getValue(HALF) != doorHalf ? (BlockState)((BlockState)((BlockState)state.setValue(FACING, (Comparable)((Direction)facingState.getValue(FACING)))).setValue((Property)OPEN, (Comparable)((Boolean)facingState.getValue((Property)OPEN)))).setValue(HINGE, (Comparable)((DoorHingeSide)facingState.getValue(HINGE))) : Blocks.AIR.defaultBlockState();
        }
        return doorHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), be, stack);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos posBelow;
        BlockState stateBelow;
        DoubleBlockHalf doorHalf;
        if (!level.isClientSide && player.isCreative() && (doorHalf = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.UPPER && (stateBelow = level.getBlockState(posBelow = pos.below())).getBlock() == state.getBlock() && stateBelow.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(posBelow, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent((Entity)player, 2001, posBelow, Block.getId((BlockState)stateBelow));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND -> (Boolean)state.getValue((Property)OPEN);
            case PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxY() && level.getBlockState(pos.above()).canBeReplaced(context)) {
            boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, pos) || BlockUtils.hasActiveSCBlockNextTo(level, pos.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHingeSide(context))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        this.onNeighborChanged(level, pos, block, orientation);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext ctx) {
        boolean isCWLower;
        Level level = ctx.getLevel();
        BlockPos clickedPos = ctx.getClickedPos();
        Direction horizontalDirection = ctx.getHorizontalDirection();
        BlockPos posAbove = clickedPos.above();
        Direction horizontalCCW = horizontalDirection.getCounterClockWise();
        BlockPos clickedPosCCW = clickedPos.relative(horizontalCCW);
        BlockState stateCCW = level.getBlockState(clickedPosCCW);
        BlockPos posAboveCCW = posAbove.relative(horizontalCCW);
        BlockState stateAboveCCW = level.getBlockState(posAboveCCW);
        Direction horizontalCW = horizontalDirection.getClockWise();
        BlockPos clickedPosCW = clickedPos.relative(horizontalCW);
        BlockState stateCW = level.getBlockState(clickedPosCW);
        BlockPos posAboveCW = posAbove.relative(horizontalCW);
        BlockState stateAboveCW = level.getBlockState(posAboveCW);
        int i = (stateCCW.isCollisionShapeFullBlock((BlockGetter)level, clickedPosCCW) ? -1 : 0) + (stateAboveCCW.isCollisionShapeFullBlock((BlockGetter)level, posAboveCCW) ? -1 : 0) + (stateCW.isCollisionShapeFullBlock((BlockGetter)level, clickedPosCW) ? 1 : 0) + (stateAboveCW.isCollisionShapeFullBlock((BlockGetter)level, posAboveCW) ? 1 : 0);
        boolean isCCWLower = stateCCW.getBlock() == this && stateCCW.getValue(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = isCWLower = stateCW.getBlock() == this && stateCW.getValue(HALF) == DoubleBlockHalf.LOWER;
        if ((!isCCWLower || isCWLower) && i <= 0) {
            if ((!isCWLower || isCCWLower) && i >= 0) {
                int stepX = horizontalDirection.getStepX();
                int stepY = horizontalDirection.getStepZ();
                Vec3 clickLocation = ctx.getClickLocation();
                double clickedX = clickLocation.x - (double)clickedPos.getX();
                double clickedY = clickLocation.z - (double)clickedPos.getZ();
                return !(stepX < 0 && !(clickedY >= 0.5) || stepX > 0 && !(clickedY <= 0.5) || stepY < 0 && !(clickedX <= 0.5) || stepY > 0 && !(clickedX >= 0.5)) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void onNeighborChanged(Level level, BlockPos firstDoorPos, Block neighborBlock, Orientation orientation) {
        BlockEntity blockEntity;
        BlockState firstDoorState = level.getBlockState(firstDoorPos);
        Owner previousOwner = null;
        BlockEntity blockEntity2 = level.getBlockEntity(firstDoorPos);
        if (blockEntity2 instanceof OwnableBlockEntity) {
            OwnableBlockEntity ownable = (OwnableBlockEntity)blockEntity2;
            previousOwner = ownable.getOwner();
        }
        if (firstDoorState.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = firstDoorPos.below();
            BlockState stateBelow = level.getBlockState(blockBelow);
            if (stateBelow.getBlock() != this) {
                level.destroyBlock(firstDoorPos, false);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(level, blockBelow, neighborBlock, orientation);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = firstDoorPos.above();
            BlockState stateAbove = level.getBlockState(blockAbove);
            if (stateAbove.getBlock() != this) {
                level.destroyBlock(firstDoorPos, false);
                drop = true;
            }
            if (!BlockUtils.isSideSolid((LevelReader)level, firstDoorPos.below(), Direction.UP)) {
                level.destroyBlock(firstDoorPos, false);
                drop = true;
                if (stateAbove.getBlock() == this) {
                    level.destroyBlock(firstDoorPos, false);
                }
            }
            if (drop) {
                if (!level.isClientSide) {
                    level.destroyBlock(firstDoorPos, false);
                    Block.popResource((Level)level, (BlockPos)firstDoorPos, (ItemStack)new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()));
                }
            } else if (neighborBlock != this) {
                boolean shouldBeOpen;
                boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos.above());
                Direction directionToCheck = ((Direction)firstDoorState.getValue(FACING)).getClockWise();
                BlockPos secondDoorPos = firstDoorPos.relative(directionToCheck);
                BlockState secondDoorState = level.getBlockState(secondDoorPos);
                if (!(secondDoorState != null && secondDoorState.getBlock() == SCContent.REINFORCED_DOOR.get() && secondDoorState.getValue(HINGE) == DoorHingeSide.RIGHT && firstDoorState.getValue(HINGE) != secondDoorState.getValue(HINGE) || (secondDoorState = level.getBlockState(secondDoorPos = firstDoorPos.relative(directionToCheck.getOpposite()))) != null && secondDoorState.getBlock() == SCContent.REINFORCED_DOOR.get() && secondDoorState.getValue(HINGE) == DoorHingeSide.LEFT && firstDoorState.getValue(HINGE) != secondDoorState.getValue(HINGE))) {
                    secondDoorPos = null;
                }
                boolean hasSecondDoorActiveSCBlock = secondDoorPos != null && (BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos.above()));
                boolean bl = shouldBeOpen = hasActiveSCBlock != hasSecondDoorActiveSCBlock || hasActiveSCBlock;
                if (shouldBeOpen != (Boolean)firstDoorState.getValue((Property)OPEN)) {
                    this.setDoorState(level, firstDoorPos, firstDoorState, shouldBeOpen);
                }
                if (secondDoorPos != null && shouldBeOpen != (Boolean)secondDoorState.getValue((Property)OPEN)) {
                    this.setDoorState(level, secondDoorPos, secondDoorState, shouldBeOpen);
                }
            }
        }
        if (previousOwner != null && (blockEntity = level.getBlockEntity(firstDoorPos)) instanceof OwnableBlockEntity) {
            OwnableBlockEntity thisBe = (OwnableBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(firstDoorPos.above());
            if (blockEntity instanceof OwnableBlockEntity) {
                OwnableBlockEntity aboveBe = (OwnableBlockEntity)blockEntity;
                thisBe.setOwner(previousOwner.getUUID(), previousOwner.getName());
                aboveBe.setOwner(previousOwner.getUUID(), previousOwner.getName());
            }
        }
    }

    public void setDoorState(Level level, BlockPos pos, BlockState state, boolean open) {
        level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
        level.playSound(null, pos, open ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posBelow = pos.below();
        BlockState stateBelow = level.getBlockState(posBelow);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return stateBelow.isFaceSturdy((BlockGetter)level, posBelow, Direction.UP);
        }
        return stateBelow.is((Block)this);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue(FACING))).cycle(HINGE);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get());
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedDoorBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, OPEN, HINGE});
    }
}

