/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public record Notes(List<NoteWrapper> notes) implements TooltipProvider
{
    public static final Notes EMPTY = new Notes(List.of());
    public static final Codec<Notes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NoteWrapper.CODEC.listOf().fieldOf("notes").forGetter(Notes::notes)).apply((Applicative)instance, Notes::new));
    public static final StreamCodec<ByteBuf, Notes> STREAM_CODEC = StreamCodec.composite((StreamCodec)NoteWrapper.STREAM_CODEC.apply(ByteBufCodecs.list()), Notes::notes, Notes::new);

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> lineAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        lineAdder.accept((Component)Utils.localize("tooltip.securitycraft.component.notes", this.notes.size()).withStyle(Utils.GRAY_STYLE));
    }

    public record NoteWrapper(int id, String instrumentName, String customSound) {
        public static final Codec<NoteWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(NoteWrapper::id), (App)Codec.STRING.fieldOf("instrument").forGetter(NoteWrapper::instrumentName), (App)Codec.STRING.fieldOf("custom_sound").forGetter(NoteWrapper::customSound)).apply((Applicative)instance, NoteWrapper::new));
        public static final StreamCodec<ByteBuf, NoteWrapper> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, NoteWrapper::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, NoteWrapper::instrumentName, (StreamCodec)ByteBufCodecs.STRING_UTF8, NoteWrapper::customSound, NoteWrapper::new);

        public boolean isSameNote(int note, NoteBlockInstrument instrument, String customSoundId) {
            return !(!this.instrumentName.equals(instrument.getSerializedName()) || instrument.isTunable() && this.id != note || !this.customSound.isEmpty() && !this.customSound.equals(customSoundId));
        }
    }
}

