/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record OwnerData(String name, String uuid) implements TooltipProvider
{
    public static final OwnerData DEFAULT = new OwnerData("", "");
    public static final Codec<OwnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(OwnerData::name), (App)Codec.STRING.fieldOf("uuid").forGetter(OwnerData::uuid)).apply((Applicative)instance, OwnerData::new));
    public static final StreamCodec<ByteBuf, OwnerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, OwnerData::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, OwnerData::uuid, OwnerData::new);

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> lineAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        KeycardData keycardData = (KeycardData)componentGetter.get(SCContent.KEYCARD_DATA);
        if (keycardData != null) {
            lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft:keycard.reader_owner", (Object[])new Object[]{this.name}).setStyle(Utils.GRAY_STYLE));
        } else {
            lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft.component.owner", (Object[])new Object[]{this.name}).setStyle(Utils.GRAY_STYLE));
        }
    }

    public OwnerData setOwnerName(String name) {
        return new OwnerData(name, this.uuid);
    }

    public OwnerData setOwnerUUID(String uuid) {
        return new OwnerData(this.name, uuid);
    }

    public Owner toOwner() {
        return new Owner(this.name, this.uuid);
    }

    public static OwnerData fromOwner(Owner owner) {
        return new OwnerData(owner.getName(), owner.getUUID());
    }

    public static OwnerData fromPlayer(Player player) {
        return new OwnerData(player.getName().getString(), player.getUUID().toString());
    }
}

