/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record BlockEntityNBTCondition(String key, boolean value) implements LootItemCondition
{
    public static final MapCodec<BlockEntityNBTCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(BlockEntityNBTCondition::key), (App)Codec.BOOL.fieldOf("value").forGetter(BlockEntityNBTCondition::value)).apply((Applicative)instance, BlockEntityNBTCondition::new));

    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public boolean test(LootContext lootContext) {
        BlockEntity be = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (be != null) {
            CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)lootContext.getLevel().registryAccess());
            return nbt.getBooleanOr(this.key, !this.value) == this.value;
        }
        return false;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)SCContent.BLOCK_ENTITY_NBT.get();
    }

    public static LootItemCondition.Builder nbt(String key, boolean value) {
        return () -> new BlockEntityNBTCondition(key, value);
    }
}

