/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import java.util.List;
import net.geforcemods.securitycraft.compat.ium.IumCompat;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.CompiledSectionMesh;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1100)
public abstract class LevelRendererMixin {
    @Shadow
    private SectionRenderDispatcher sectionRenderDispatcher;
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private List<Entity> visibleEntities;
    @Shadow
    private int visibleEntityCount;
    @Unique
    private boolean securitycraft$entityOutlineRendered;

    @Shadow
    protected abstract boolean collectVisibleEntities(Camera var1, Frustum var2, List<Entity> var3);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;compileSections(Lnet/minecraft/client/Camera;)V")})
    private void securitycraft$afterSetupRender(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, Matrix4f frustumMatrix, Matrix4f projectionMatrix, GpuBufferSlice bufferSlice, Vector4f fogColor, boolean renderSky, CallbackInfo ci, @Local Frustum frustum) {
        if (IumCompat.isActive() && FrameFeedHandler.hasFeeds()) {
            ProfilerFiller profiler = Profiler.get();
            profiler.popPush("cullEntities");
            this.visibleEntities.clear();
            this.securitycraft$entityOutlineRendered = this.collectVisibleEntities(camera, frustum, this.visibleEntities);
            this.visibleEntityCount = this.visibleEntities.size();
            profiler.popPush("compile_sections");
        }
        if (FrameFeedHandler.isCapturingCamera()) {
            FrameFeedHandler.getCurrentlyCapturedFeed().setBackgroundColor(fogColor);
        }
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;compileSections(Lnet/minecraft/client/Camera;)V"), ordinal=3)
    private boolean securitycraft$modifyEntityOutlineRendered(boolean original) {
        if (IumCompat.isActive() && this.securitycraft$entityOutlineRendered) {
            this.securitycraft$entityOutlineRendered = false;
            return true;
        }
        return original;
    }

    @Inject(method={"setupRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onSetupRender(Camera camera, Frustum frustum, boolean hasCapturedFrustum, boolean isSpectator, CallbackInfo ci) {
        if (FrameFeedHandler.isCapturingCamera() && !IumCompat.isActive()) {
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SectionOcclusionGraph;waitAndReset(Lnet/minecraft/client/renderer/ViewArea;)V")})
    private void securitycraft$onAllChanged(CallbackInfo ci) {
        CameraViewAreaExtension.allChanged(this.sectionRenderDispatcher, (Level)this.level);
    }

    @Inject(method={"isSectionCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onIsSectionCompiled(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        SectionPos sectionPos;
        SectionRenderDispatcher.RenderSection renderSection;
        if (FrameFeedHandler.isCapturingCamera() && (renderSection = CameraViewAreaExtension.rawFetch((sectionPos = SectionPos.of((BlockPos)pos)).x(), sectionPos.y(), sectionPos.z(), false)) != null && renderSection.sectionMesh.get() != CompiledSectionMesh.UNCOMPILED) {
            cir.setReturnValue((Object)true);
        }
    }
}

