/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClearChangeDetectorServer(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClearChangeDetectorServer> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("clear_change_detector_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClearChangeDetectorServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClearChangeDetectorServer::pos, ClearChangeDetectorServer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockChangeDetectorBlockEntity be;
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof BlockChangeDetectorBlockEntity && (be = (BlockChangeDetectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = be.getBlockState();
            be.getEntries().clear();
            be.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
            if (((Boolean)state.getValue((Property)BlockChangeDetectorBlock.POWERED)).booleanValue()) {
                level.setBlockAndUpdate(this.pos, (BlockState)state.setValue((Property)BlockChangeDetectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                BlockUtils.updateIndirectNeighbors(level, this.pos, (Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), AbstractPanelBlock.getConnectedDirection(state).getOpposite());
            }
        }
    }
}

