/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetCameraPowered(BlockPos pos, boolean powered) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetCameraPowered> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("set_camera_powered"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetCameraPowered> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetCameraPowered::pos, (StreamCodec)ByteBufCodecs.BOOL, SetCameraPowered::powered, SetCameraPowered::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        IModuleInventory moduleInv;
        IOwnable ownable;
        Player player = ctx.player();
        Level level = player.level();
        BlockEntity be = level.getBlockEntity(this.pos);
        if (!player.isSpectator() && be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isAllowed((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            level.setBlockAndUpdate(this.pos, (BlockState)state.setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
            level.updateNeighborsAt(this.pos.relative((Direction)state.getValue(SecurityCameraBlock.FACING), -1), state.getBlock());
        }
    }
}

