/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public record SecurityCameraSpecialRenderer(SecurityCameraModel model, ResourceLocation texture, float rotation, Optional<Integer> lensColor, Optional<Integer> light) implements NoDataSpecialModelRenderer
{
    public void render(ItemDisplayContext ctx, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean glint) {
        int color = this.lensColor.orElseGet(() -> {
            this.model.cameraRotationPoint2.visible = false;
            return 0x70FFFF;
        });
        this.model.rotateCameraY(this.rotation);
        this.model.renderToBuffer(pose, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)this.texture)), this.light.orElse(packedLight), packedOverlay, ARGB.color((int)255, (int)color));
        this.model.cameraRotationPoint2.visible = true;
    }

    public void getExtents(Set<Vector3f> extents) {
        PoseStack poseStack = new PoseStack();
        this.model.rotateCameraY(this.rotation);
        this.model.root().getExtentsForGui(poseStack, extents);
    }

    public record Unbaked(ResourceLocation texture, float rotation, Optional<Integer> lensColor, Optional<Integer> light) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::rotation), (App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("lens_color").forGetter(Unbaked::lensColor), (App)Codec.INT.optionalFieldOf("light").forGetter(Unbaked::light)).apply((Applicative)i, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            SecurityCameraModel model = new SecurityCameraModel(modelSet.bakeLayer(ClientHandler.SECURITY_CAMERA_LOCATION));
            return new SecurityCameraSpecialRenderer(model, this.texture.withPrefix("textures/entity/security_camera/").withSuffix(".png"), this.rotation, this.lensColor, this.light);
        }
    }
}

