/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TrophySystemRenderer
implements BlockEntityRenderer<TrophySystemBlockEntity> {
    public static final int RENDER_DISTANCE = 50;

    public TrophySystemRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TrophySystemBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay, cameraPos);
        Projectile target = be.getTarget();
        if (target == null) {
            return;
        }
        VertexConsumer builder = buffer.getBuffer(RenderType.lines());
        Matrix4f positionMatrix = pose.last().pose();
        BlockPos pos = be.getBlockPos();
        ItemStack lens = be.getLensContainer().getItem(0);
        int r = 255;
        int g = 255;
        int b = 255;
        if (lens.has(DataComponents.DYED_COLOR)) {
            int color = ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb();
            r = color >> 16 & 0xFF;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
        }
        builder.addVertex(positionMatrix, 0.5f, 0.75f, 0.5f).setColor(r, g, b, 255).setNormal(1.0f, 1.0f, 1.0f);
        builder.addVertex(positionMatrix, (float)(target.getX() - (double)pos.getX()), (float)(target.getY() - (double)pos.getY()), (float)(target.getZ() - (double)pos.getZ())).setColor(r, g, b, 255).setNormal(1.0f, 1.0f, 1.0f);
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(TrophySystemBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(50.0);
    }
}

