/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.StateSelector;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ProjectorScreen
extends AbstractContainerScreen<ProjectorMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/projector.png");
    private static final Component SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]);
    private ProjectorBlockEntity be;
    private TextHoverChecker slotHoverChecker;
    private CallbackSlider projectionWidthSlider;
    private CallbackSlider projectionHeightSlider;
    private CallbackSlider projectionRangeSlider;
    private CallbackSlider projectionOffsetSlider;
    private TogglePictureButton horizontalToggleButton;
    private CallbackCheckbox overrideCheckbox;
    private StateSelector stateSelector;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.imageHeight = 235;
    }

    public void init() {
        super.init();
        this.leftPos += 90;
        int left = this.leftPos + (this.imageWidth - this.sliderWidth) / 2;
        this.projectionWidthSlider = (CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(left, this.topPos + 57, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.width", ""), (Component)Component.empty(), 1.0, 10.0, this.be.getProjectionWidth(), true, this::applySliderValue));
        this.projectionWidthSlider.setFGColor(0xE0E0E0);
        this.projectionWidthSlider.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:projector.width.description", new Object[0])));
        this.projectionHeightSlider = (CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(left, this.topPos + 78, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.height", ""), (Component)Component.empty(), 1.0, 10.0, this.be.getProjectionHeight(), true, this::applySliderValue));
        this.projectionHeightSlider.setFGColor(0xE0E0E0);
        this.projectionHeightSlider.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:projector.height.description", new Object[0])));
        this.projectionRangeSlider = (CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(left, this.topPos + 99, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.range", ""), (Component)Component.empty(), 1 - (this.be.isHorizontal() ? 16 : 0), 30 - (this.be.isHorizontal() ? 16 : 0), this.be.getProjectionRange() - (this.be.isHorizontal() ? 16 : 0), true, this::applySliderValue));
        this.projectionRangeSlider.setFGColor(0xE0E0E0);
        this.projectionRangeSlider.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:projector.range.description", new Object[0])));
        this.projectionOffsetSlider = (CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(left, this.topPos + 120, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), (Component)Component.empty(), -10.0, 10.0, this.be.getProjectionOffset(), true, this::applySliderValue));
        this.projectionOffsetSlider.setFGColor(0xE0E0E0);
        this.projectionOffsetSlider.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:projector.offset.description", new Object[0])));
        this.horizontalToggleButton = (TogglePictureButton)this.addRenderableWidget((GuiEventListener)new TogglePictureButton(left + this.sliderWidth - 20, this.topPos + 36, 20, 20, 2, 16, 16, 2, button -> {
            boolean horizontal = !this.be.isHorizontal();
            this.be.setHorizontal(horizontal);
            this.updateHorizontalToggleButtonTooltip();
            this.projectionRangeSlider.setMinValue(this.projectionRangeSlider.getMinValue() - (double)(horizontal ? 16 : -16));
            this.projectionRangeSlider.setMaxValue(this.projectionRangeSlider.getMaxValue() - (double)(horizontal ? 16 : -16));
            this.projectionRangeSlider.setValue(this.projectionRangeSlider.getValue() - (double)(horizontal ? 16 : -16));
            this.applySliderValue(this.projectionRangeSlider);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncProjector(this.be.getBlockPos(), this.be.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, SecurityCraft.resLoc("projector/vertical"), SecurityCraft.resLoc("projector/horizontal")));
        this.horizontalToggleButton.setCurrentIndex(this.be.isHorizontal() ? 1 : 0);
        this.updateHorizontalToggleButtonTooltip();
        this.overrideCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(left + this.sliderWidth - 41, this.topPos + 36, 20, 20, (Component)Component.empty(), this.be.isOverridingBlocks(), newValue -> {
            this.be.setOverridingBlocks((boolean)newValue);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncProjector(this.be.getBlockPos(), this.be.isOverridingBlocks() ? 1 : 0, SyncProjector.DataType.OVERRIDING_BLOCKS), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.updateOverrideCheckboxTooltip();
        }, 0));
        this.updateOverrideCheckboxTooltip();
        this.slotHoverChecker = new TextHoverChecker(this.topPos + 22, this.topPos + 39, this.leftPos + 78, this.leftPos + 95, SLOT_TOOLTIP);
        this.stateSelector = (StateSelector)this.addRenderableWidget(new StateSelector((StateSelectorAccessMenu)this.menu, this.title, this.leftPos - 190, this.topPos + 7, 0, 197, 0, 173, -60));
        this.stateSelector.init(this.minecraft, this.width, this.height);
    }

    private void updateHorizontalToggleButtonTooltip() {
        this.horizontalToggleButton.setTooltip(Tooltip.create((Component)(this.be.isHorizontal() ? Utils.localize("gui.securitycraft:projector.horizontal", new Object[0]) : Utils.localize("gui.securitycraft:projector.vertical", new Object[0]))));
    }

    private void updateOverrideCheckboxTooltip() {
        this.overrideCheckbox.setTooltip(Tooltip.create((Component)(this.be.isOverridingBlocks() ? Utils.localize("gui.securitycraft:projector.isOverridingBlocks.yes", new Object[0]) : Utils.localize("gui.securitycraft:projector.isOverridingBlocks.no", new Object[0]))));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && ((ProjectorMenu)this.menu).be.isContainerEmpty()) {
            guiGraphics.setTooltipForNextFrame(this.font, this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, -12566464, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (this.stateSelector != null) {
            this.stateSelector.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stateSelector != null && this.stateSelector.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getGuiExtraAreas();
        }
        return List.of();
    }

    public void onClose() {
        super.onClose();
        if (this.stateSelector.getState() != null) {
            this.be.setProjectedState(this.stateSelector.getState());
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncProjector(this.be.getBlockPos(), this.stateSelector.getState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void applySliderValue(CallbackSlider slider) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (slider == this.projectionWidthSlider) {
            data = slider.getValueInt();
            this.be.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (slider == this.projectionHeightSlider) {
            data = slider.getValueInt();
            this.be.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (slider == this.projectionRangeSlider) {
            data = slider.getValueInt();
            if (this.be.isHorizontal()) {
                data += 16;
            }
            this.be.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (slider == this.projectionOffsetSlider) {
            data = slider.getValueInt();
            this.be.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncProjector(this.be.getBlockPos(), data, dataType), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

