/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.ToggleScrollList;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class RiftStabilizerScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    public final Component scrollListTitle;
    public final Component smartModuleTooltip;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private boolean hasSmartModule;
    private boolean hasRedstoneModule;
    private RiftStabilizerBlockEntity be;

    public RiftStabilizerScreen(RiftStabilizerBlockEntity be) {
        super(be.getName());
        this.be = be;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        this.hasRedstoneModule = be.isModuleEnabled(ModuleType.REDSTONE);
        this.scrollListTitle = Utils.localize("gui.securitycraft:rift_stabilizer.teleportationTypes", new Object[0]);
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:rift_stabilizer.toggle", new Object[0]) : Utils.localize("gui.securitycraft:rift_stabilizer.moduleRequired", new Object[0]);
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new ToggleScrollList<RiftStabilizerBlockEntity.TeleportationType>(this.be, this.hasSmartModule, this.hasRedstoneModule, this.minecraft, this.imageWidth - 24, this.imageHeight - 60, this.topPos + 40, this.leftPos + 12));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, -12566464, false);
        guiGraphics.drawString(this.font, this.scrollListTitle, this.width / 2 - this.font.width((FormattedText)this.scrollListTitle) / 2, this.topPos + 31, -12566464, false);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

