/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class CollapsibleTextList
extends Button {
    private static final Component PLUS = Component.literal((String)"+ ");
    private static final Component MINUS = Component.literal((String)"- ");
    private final int threeDotsWidth;
    private final int maximumHeight;
    private int currentHeight;
    private int previousHeight;
    private final Component originalDisplayString;
    private final List<List<FormattedCharSequence>> textLines;
    private final BiPredicate<Integer, Integer> extraHoverCheck;
    private boolean open;
    private boolean isMessageTooLong;
    private int initialY;

    public CollapsibleTextList(int xPos, int yPos, int width, Component displayString, List<? extends Component> textLines, Button.OnPress onPress, BiPredicate<Integer, Integer> extraHoverCheck) {
        super(xPos, yPos, width, 12, displayString, onPress, s -> Component.empty());
        this.threeDotsWidth = Minecraft.getInstance().font.width("...");
        this.textLines = new ArrayList<List<FormattedCharSequence>>();
        this.open = true;
        this.isMessageTooLong = false;
        this.initialY = -1;
        this.originalDisplayString = displayString;
        this.switchOpenStatus();
        Font font = Minecraft.getInstance().font;
        int amountOfLines = 0;
        for (Component component : textLines) {
            List splitLines = font.split((FormattedText)component, width - 5);
            amountOfLines += splitLines.size();
            this.textLines.add(splitLines);
        }
        Objects.requireNonNull(font);
        this.maximumHeight = this.height + amountOfLines * 9 + textLines.size() * 3;
        this.currentHeight = this.previousHeight = this.height;
        this.extraHoverCheck = extraHoverCheck;
    }

    public void tick() {
        this.previousHeight = this.currentHeight;
        if (this.open) {
            if (this.currentHeight < this.maximumHeight) {
                this.currentHeight = Math.min(this.currentHeight + 40, this.maximumHeight);
            }
        } else if (this.currentHeight > this.height) {
            this.currentHeight = Math.max(this.height, this.currentHeight - 40);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.isHovered &= this.extraHoverCheck.test(mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        int heightOffset = (this.height - 8) / 2;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + font.width((FormattedText)this.getMessage()) / 2 + 3, this.getY() + heightOffset, this.getFGColor());
        int renderedLines = 0;
        int interpolatedHeight = (int)Mth.lerp((float)partialTick, (float)this.previousHeight, (float)this.currentHeight);
        guiGraphics.fillGradient(this.getX(), this.getY() + this.height, this.getX() + this.width, this.getY() + interpolatedHeight, -1072689136, -804253680);
        for (int i = 0; i < this.textLines.size(); ++i) {
            int n = this.getY() + 2 + this.height;
            Objects.requireNonNull(font);
            int textY = n + renderedLines * 9 + i * 12;
            List<FormattedCharSequence> linesToDraw = this.textLines.get(i);
            if (i > 0) {
                guiGraphics.fillGradient(this.getX() + 1, textY - 3, this.getX() + this.width - 2, textY - 2, -1432313696, -1432313696);
            }
            for (int lineIndex = 0; lineIndex < linesToDraw.size(); ++lineIndex) {
                Objects.requireNonNull(font);
                int lineY = textY + lineIndex * 9;
                Objects.requireNonNull(font);
                if (lineY + 9 > this.getY() + interpolatedHeight) {
                    return;
                }
                guiGraphics.drawString(font, linesToDraw.get(lineIndex), this.getX() + 2, lineY, this.getFGColor(), false);
            }
            renderedLines += linesToDraw.size() - 1;
        }
    }

    public void renderLongMessageTooltip(GuiGraphics guiGraphics, Font font) {
        Screen currentScreen;
        if (this.isMessageTooLong && this.isHoveredOrFocused() && (currentScreen = Minecraft.getInstance().screen) != null) {
            guiGraphics.setTooltipForNextFrame(font, this.originalDisplayString, this.getX() + 1, this.getY() + this.height + 2);
        }
    }

    public void setMessage(Component message) {
        int cutoff;
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)message);
        if (stringWidth > (cutoff = this.width - 6) && stringWidth > this.threeDotsWidth) {
            this.isMessageTooLong = true;
            message = Component.literal((String)(font.substrByWidth((FormattedText)message, cutoff - this.threeDotsWidth).getString() + "..."));
        }
        super.setMessage(message);
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getMaximumHeight() {
        return this.open ? this.maximumHeight : this.height;
    }

    public void onPress() {
        this.switchOpenStatus();
        super.onPress();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.extraHoverCheck.test((int)mouseX, (int)mouseY) && super.isMouseOver(mouseX, mouseY);
    }

    public void setY(int y) {
        if (this.initialY == -1) {
            this.initialY = y;
        }
        super.setY(y);
    }

    public void switchOpenStatus() {
        this.open = !this.open;
        this.setMessage((Component)(this.open ? MINUS : PLUS).copy().append(this.originalDisplayString));
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

