/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class ToggleScrollList<T>
extends ScrollPanel {
    private static final ResourceLocation CONFIRM_SPRITE = SecurityCraft.mcResLoc("container/beacon/confirm");
    private static final ResourceLocation CANCEL_SPRITE = SecurityCraft.mcResLoc("container/beacon/cancel");
    private static final int SLOT_HEIGHT = 12;
    private final int listLength;
    private final List<T> orderedFilterList;
    private final Map<T, Component> typeNames = new HashMap<T, Component>();
    private final Minecraft mc;
    private final IToggleableEntries<T> be;
    private final boolean hasSmartModule;
    private final boolean hasRedstoneModule;

    public ToggleScrollList(IToggleableEntries<T> be, boolean hasSmartModule, boolean hasRedstoneModule, Minecraft mc, int width, int height, int top, int left) {
        super(mc, width, height, top, left);
        this.mc = mc;
        this.be = be;
        this.hasSmartModule = hasSmartModule;
        this.hasRedstoneModule = hasRedstoneModule;
        this.orderedFilterList = new ArrayList<T>(be.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == be.getDefaultType()) {
                return 1;
            }
            if (e2 == be.getDefaultType()) {
                return -1;
            }
            return Utils.localize(e1.toString(), new Object[0]).getString().compareTo(Utils.localize(e2.toString(), new Object[0]).getString());
        });
        this.listLength = this.orderedFilterList.size();
    }

    protected int getContentHeight() {
        Objects.requireNonNull(this.mc.font);
        int height = this.listLength * (9 + 3);
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        double relativeMouseY;
        int slotIndex;
        if (this.hasSmartModule && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && slotIndex < this.listLength && (relativeMouseY = this.mc.mouseHandler.ypos() * (double)this.mc.getWindow().getGuiScaledHeight() / (double)this.mc.getWindow().getScreenHeight()) >= (double)this.top && relativeMouseY <= (double)this.bottom) {
            this.be.toggleFilter(this.orderedFilterList.get(slotIndex));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
        this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int comparatorOutput;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        int slotBottom = baseY + (slotIndex + 1) * 12;
        if (this.hasRedstoneModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom && (comparatorOutput = this.be.getComparatorOutputFunction().applyAsInt(this.orderedFilterList.get(slotIndex))) > 0) {
            guiGraphics.setTooltipForNextFrame(this.mc.font, (Component)Component.translatable((String)"gui.securitycraft:toggleList.comparatorOutput", (Object[])new Object[]{comparatorOutput}), this.right - 8, slotBottom);
        }
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int slotBuffer = 8;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (this.hasSmartModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
            int min = this.left;
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            guiGraphics.fill(min, slotTop - 2, max, slotTop + slotBuffer + 2, -8355712);
            guiGraphics.fill(min + 1, slotTop - 1, max - 1, slotTop + slotBuffer + 1, -16777216);
        }
        int i = 0;
        for (T type : this.orderedFilterList) {
            Component name = this.typeNames.computeIfAbsent(type, t -> Utils.localize(t == this.be.getDefaultType() ? this.be.getDefaultTypeName() : t.toString(), new Object[0]));
            int yStart = relativeY + 12 * i;
            guiGraphics.drawString(font, name, this.left + this.width / 2 - font.width((FormattedText)name) / 2, yStart, -3750202, false);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.be.getFilter(type) ? CONFIRM_SPRITE : CANCEL_SPRITE, this.left + 1, yStart - 3, 12, 12);
            ++i;
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }
}

