/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.BiPredicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IBlockMine;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockUtils {
    private BlockUtils() {
    }

    public static boolean isSideSolid(LevelReader level, BlockPos pos, Direction side) {
        return level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, side);
    }

    public static Level.ExplosionInteraction getExplosionInteraction() {
        return (Boolean)ConfigHandler.SERVER.mineExplosionsBreakBlocks.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
    }

    public static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(level, pos, be, activator));
    }

    private static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos, BlockEntity be, IDoorActivator activator) {
        for (Direction dir : Direction.values()) {
            IOwnable ownable;
            BlockEntity offsetBe;
            BlockPos offsetPos = pos.relative(dir);
            BlockState offsetState = level.getBlockState(offsetPos);
            if (activator.getBlocks().contains(offsetState.getBlock()) && activator.isPowering(level, offsetPos, offsetState, offsetBe = level.getBlockEntity(offsetPos), dir, 1) && (!(offsetBe instanceof IOwnable) || (ownable = (IOwnable)offsetBe).getOwner().owns((IOwnable)be))) {
                return true;
            }
            if (level.getSignal(offsetPos, dir) != 15 || offsetState.isSignalSource()) continue;
            for (Direction dirOffset : Direction.values()) {
                IOwnable ownable2;
                BlockEntity offsetBe2;
                if (dirOffset.getOpposite() == dir) continue;
                BlockPos newOffsetPos = offsetPos.relative(dirOffset);
                offsetState = level.getBlockState(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.getBlock()) || !activator.isPowering(level, newOffsetPos, offsetState, offsetBe2 = level.getBlockEntity(newOffsetPos), dirOffset, 2) || offsetBe2 instanceof IOwnable && !(ownable2 = (IOwnable)offsetBe2).getOwner().owns((IOwnable)be)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends BlockEntity> boolean isAllowedToExtractFromProtectedObject(Direction side, T be) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, (IOwnable)be, be.getLevel(), be.getBlockPos());
    }

    public static boolean isAllowedToExtractFromProtectedObject(Direction side, IOwnable ownable, Level level, BlockPos pos) {
        if (side != null && level != null) {
            BlockPos offsetPos = pos.relative(side);
            BlockState offsetState = level.getBlockState(offsetPos);
            for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
                if (offsetState.getBlock() != extractionBlock.getBlock()) continue;
                return extractionBlock.canExtract(ownable, level, offsetPos, offsetState);
            }
        }
        return false;
    }

    public static boolean isInsideUnownedReinforcedBlocks(Level level, Player player, Vec3 pos, float entityWidth) {
        float width = entityWidth * 0.8f;
        AABB inWallArea = AABB.ofSize((Vec3)pos, (double)width, (double)1.0E-6, (double)width);
        return BlockPos.betweenClosedStream((AABB)inWallArea).anyMatch(testPos -> {
            IOwnable ownable;
            BlockEntity patt0$temp;
            BlockState wallState = level.getBlockState(testPos);
            return wallState.getBlock() instanceof IReinforcedBlock && wallState.isSuffocating((BlockGetter)level, testPos) && (!((patt0$temp = level.getBlockEntity(testPos)) instanceof IOwnable) || !(ownable = (IOwnable)patt0$temp).isOwnedBy((Entity)player)) && Shapes.joinIsNotEmpty((VoxelShape)wallState.getCollisionShape((BlockGetter)level, testPos).move((double)testPos.getX(), (double)testPos.getY(), (double)testPos.getZ()), (VoxelShape)Shapes.create((AABB)inWallArea), (BooleanOp)BooleanOp.AND);
        });
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block) {
        BlockUtils.updateIndirectNeighbors(level, pos, block, Direction.values());
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block, Direction ... directions) {
        level.updateNeighborsAt(pos, block);
        for (Direction dir : directions) {
            level.updateNeighborsAt(pos.relative(dir), block);
        }
    }

    public static void removeInSequence(BiPredicate<Direction, BlockState> stateMatcher, LevelAccessor level, BlockPos pos, Direction ... directions) {
        for (Direction direction : directions) {
            int i = 1;
            BlockPos modifiedPos = pos.relative(direction, i);
            while (stateMatcher.test(direction, level.getBlockState(modifiedPos))) {
                level.removeBlock(modifiedPos, false);
                modifiedPos = pos.relative(direction, ++i);
            }
        }
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, float destroyTimeForOwner, BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress(destroyProgress, destroyTimeForOwner, state, player, level, pos, false);
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, float destroyTimeForOwner, BlockState state, Player player, BlockGetter level, BlockPos pos, boolean allowDefault) {
        BlockEntity be;
        boolean isBlockMine = state.getBlock() instanceof IBlockMine;
        if ((((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() || isBlockMine) && (be = level.getBlockEntity(pos)) instanceof IOwnable) {
            boolean isOwned;
            IOwnable ownable = (IOwnable)be;
            if (state.destroySpeed == -1.0f && ((isOwned = ownable.isOwnedBy((Entity)player)) || isBlockMine || ((Boolean)ConfigHandler.SERVER.allowBreakingNonOwnedBlocks.get()).booleanValue() || allowDefault && ownable.getOwner().isDefaultOwner())) {
                state.destroySpeed = destroyTimeForOwner;
                float newDestroyProgress = destroyProgress.get(state, player, level, pos) / (float)(isOwned || isBlockMine ? 1.0 : ConfigHandler.SERVER.nonOwnedBreakingSlowdown.getAsDouble());
                state.destroySpeed = -1.0f;
                return newDestroyProgress;
            }
        }
        return destroyProgress.get(state, player, level, pos);
    }

    @FunctionalInterface
    public static interface DestroyProgress {
        public float get(BlockState var1, Player var2, BlockGetter var3, BlockPos var4);
    }
}

