/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PlayerUtils {
    private PlayerUtils() {
    }

    public static <T extends Player> T getPlayerFromName(String name) {
        List players = null;
        players = EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.getInstance().level.players() : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
        if (players != null) {
            for (Player player : players) {
                if (!player.getName().getString().equals(name)) continue;
                return (T)player;
            }
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            for (AbstractClientPlayer player : Minecraft.getInstance().level.players()) {
                if (player == null || !player.getName().getString().equals(name)) continue;
                return true;
            }
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(name) != null;
    }

    public static void sendMessageToPlayer(String playerName, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        Object player = PlayerUtils.getPlayerFromName(playerName);
        if (player != null) {
            PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
        }
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color, boolean shouldSendFromClient) {
        if (player != null && player.level().isClientSide == shouldSendFromClient) {
            player.displayClientMessage((Component)Component.literal((String)"[").append((Component)prefix.setStyle(Style.EMPTY.withColor(color))).append((Component)Component.literal((String)"] ")).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)).append((Component)text), false);
        }
    }

    public static ItemStack getItemStackFromAnyHand(Player player, Item item) {
        if (player.getMainHandItem().is(item)) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().is(item)) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    public static boolean isPlayerMountedOnCamera(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return ClientHandler.isPlayerMountedOnCamera();
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.getCamera() instanceof SecurityCamera;
        }
        return false;
    }

    public static Component getOwnerComponent(Owner owner) {
        TeamUtils.TeamRepresentation teamRepresentation = TeamUtils.getTeamRepresentation(owner);
        if (teamRepresentation != null) {
            return Utils.localize("messages.securitycraft:teamOwner", Component.literal((String)teamRepresentation.name()).withStyle(Style.EMPTY.withColor(teamRepresentation.color()))).withStyle(ChatFormatting.GRAY);
        }
        return Component.literal((String)owner.getName());
    }

    public static Owner getOwnerFromPlayerOrMask(Player player) {
        ItemStack headItem = player.getItemBySlot(EquipmentSlot.HEAD);
        if (headItem.is(SCContent.INCOGNITO_MASK)) {
            return new Owner(PlayerUtils.getNameFromMask(headItem), "ownerUUID");
        }
        return new Owner(player);
    }

    public static String getNameFromPlayerOrMask(Player player) {
        ItemStack headItem = player.getItemBySlot(EquipmentSlot.HEAD);
        if (headItem.is(SCContent.INCOGNITO_MASK)) {
            return PlayerUtils.getNameFromMask(headItem);
        }
        return player.getName().getString();
    }

    private static String getNameFromMask(ItemStack mask) {
        return mask.has(DataComponents.CUSTOM_NAME) ? mask.getCustomName().getString() : "owner";
    }

    public static Owner getSkullOwner(Player player) {
        ResolvableProfile profile;
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (stack.getItem() == Items.PLAYER_HEAD && (profile = (ResolvableProfile)stack.get(DataComponents.PROFILE)) != null) {
            Optional profileUUID = profile.id();
            String uuid = "ownerUUID";
            if (profileUUID.isPresent()) {
                uuid = ((UUID)profileUUID.get()).toString();
            }
            return new Owner(profile.name().orElse("ownerName"), uuid);
        }
        return null;
    }

    public static Collection<ServerPlayer> getPlayerListFromOwner(Owner owner) {
        ServerPlayer player = (ServerPlayer)PlayerUtils.getPlayerFromName(owner.getName());
        if (player != null) {
            return Arrays.asList(player);
        }
        return new ArrayList<ServerPlayer>();
    }
}

